/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.geoserver.data.test.MockData;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.AbstractConfirmRemovalPanelTest;
import org.geoserver.security.web.data.ConfirmRemovalDataAccessRulePanel;
import org.geoserver.security.web.data.SelectionDataRuleRemovalLink;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.junit.Test;

public class ConfirmRemovalDataAccessRulePanelTest
extends AbstractConfirmRemovalPanelTest<DataAccessRule> {
    private static final long serialVersionUID = 1L;

    @Test
    public void testRemoveRule() throws Exception {
        this.initializeForXML();
        this.removeObject();
    }

    @Override
    protected void setupPanel(final List<DataAccessRule> roots) {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                return new ConfirmRemovalDataAccessRulePanel(id, roots){
                    private static final long serialVersionUID = 1L;

                    protected IModel<String> canRemove(DataAccessRule data) {
                        SelectionDataRuleRemovalLink link = new SelectionDataRuleRemovalLink("XXX", null, null);
                        return link.canRemove(data);
                    }
                };
            }
        }));
    }

    @Override
    protected DataAccessRule getRemoveableObject() throws Exception {
        for (DataAccessRule rule : DataAccessRuleDAO.get().getRules()) {
            if (!MockData.CITE_PREFIX.equals(rule.getRoot()) || !MockData.BRIDGES.getLocalPart().equals(rule.getLayer())) continue;
            return rule;
        }
        return null;
    }

    @Override
    protected DataAccessRule getProblematicObject() throws Exception {
        return null;
    }

    @Override
    protected String getProblematicObjectRegExp() throws Exception {
        return null;
    }

    @Override
    protected String getRemoveableObjectRegExp() throws Exception {
        DataAccessRule rule = this.getRemoveableObject();
        return ".*" + rule.getRoot() + ".*" + rule.getLayer() + ".*" + "ROLE_WFS" + ".*";
    }
}

