/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.Form;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.group.AbstractGroupPage;
import org.geoserver.security.web.user.UserListProvider;
import org.geoserver.security.web.user.UserTablePanel;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class EditGroupPage
extends AbstractGroupPage {
    public EditGroupPage(String userGroupServiceName, final GeoServerUserGroup group) {
        super(userGroupServiceName, group.copy());
        this.get("form:groupname").setEnabled(false);
        ((Form)this.get("form")).add(new Component[]{new UserTablePanel("users", userGroupServiceName, new GeoServerDataProvider<GeoServerUser>(){

            protected List<GeoServerDataProvider.Property<GeoServerUser>> getProperties() {
                return Arrays.asList(UserListProvider.USERNAME);
            }

            protected List<GeoServerUser> getItems() {
                GeoServerUserGroupService ugService = EditGroupPage.this.getUserGroupService(EditGroupPage.this.userGroupServiceName);
                try {
                    return new ArrayList<GeoServerUser>(ugService.getUsersForGroup(group));
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        }).setFilterable(false)});
    }

    @Override
    protected void onFormSubmit(GeoServerUserGroup group) throws IOException {
        UserGroupStoreValidationWrapper store = null;
        try {
            if (this.hasUserGroupStore(this.userGroupServiceName)) {
                store = new UserGroupStoreValidationWrapper(this.getUserGroupStore(this.userGroupServiceName));
                store.updateGroup(group);
                store.store();
            }
        }
        catch (IOException ex) {
            try {
                store.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        GeoServerRoleStore gaStore = null;
        try {
            if (this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName())) {
                gaStore = this.getRoleStore(this.getSecurityManager().getActiveRoleService().getName());
                gaStore = new RoleStoreValidationWrapper(gaStore, new GeoServerUserGroupService[0]);
                SortedSet orig = gaStore.getRolesForGroup(group.getGroupname());
                HashSet<GeoServerRole> add = new HashSet<GeoServerRole>();
                HashSet<GeoServerRole> remove = new HashSet<GeoServerRole>();
                this.rolePalette.diff(orig, add, remove);
                for (GeoServerRole role : add) {
                    gaStore.associateRoleToGroup(role, group.getGroupname());
                }
                for (GeoServerRole role : remove) {
                    gaStore.disAssociateRoleFromGroup(role, group.getGroupname());
                }
                gaStore.store();
            }
        }
        catch (IOException ex) {
            try {
                gaStore.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }
}

