/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.web.SecurityNamedServicePanel;

public class PasswordPolicyPanel
extends SecurityNamedServicePanel<PasswordPolicyConfig> {
    MaxLengthPanel maxLengthPanel;

    public PasswordPolicyPanel(String id, IModel<PasswordPolicyConfig> model) {
        super(id, model);
        PasswordPolicyConfig pwPolicy = (PasswordPolicyConfig)model.getObject();
        this.add(new Component[]{new CheckBox("digitRequired")});
        this.add(new Component[]{new CheckBox("uppercaseRequired")});
        this.add(new Component[]{new CheckBox("lowercaseRequired")});
        this.add(new Component[]{new TextField("minLength")});
        boolean unlimited = pwPolicy.getMaxLength() == -1;
        this.add(new Component[]{new AjaxCheckBox("unlimitedMaxLength", (IModel)new Model((Serializable)Boolean.valueOf(unlimited))){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean value = (Boolean)this.getModelObject();
                PasswordPolicyPanel.this.maxLengthPanel.setVisible(value == false);
                if (value.booleanValue()) {
                    PasswordPolicyPanel.this.maxLengthPanel.setUnlimited();
                }
                target.add(new Component[]{PasswordPolicyPanel.this.maxLengthPanel.getParent()});
            }
        }});
        Component[] componentArray = new Component[1];
        this.maxLengthPanel = (MaxLengthPanel)new MaxLengthPanel("maxLength").setVisible(!unlimited);
        componentArray[0] = this.maxLengthPanel;
        this.add(componentArray);
    }

    @Override
    public void doSave(PasswordPolicyConfig config) throws Exception {
        this.getSecurityManager().savePasswordPolicy(config);
    }

    @Override
    public void doLoad(PasswordPolicyConfig config) throws Exception {
        this.getSecurityManager().loadPasswordPolicyConfig(config.getName());
    }

    class MaxLengthPanel
    extends FormComponentPanel {
        public MaxLengthPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new TextField("maxLength")});
            this.setOutputMarkupId(true);
        }

        public void setUnlimited() {
            this.get("maxLength").setDefaultModelObject((Object)-1);
        }
    }
}

