/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityHomePageContentProvider;
import org.geoserver.web.GeoServerApplication;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class SecurityHomePageContentProviderTest
extends AbstractSecurityWicketTestSupport {
    @Test
    public void testIsEmbeddedDataDirectoryTrue() {
        GeoServerApplication app = new GeoServerApplication();
        app.setApplicationContext((ApplicationContext)applicationContext);
        app.setServletContext((ServletContext)new MockServletContext((Application)app, "target"));
        Assert.assertTrue((boolean)SecurityHomePageContentProvider.isEmbeddedDataDirectory((GeoServerApplication)app));
    }

    @Test
    public void testIsEmbeddedDataDirectoryFalse() {
        GeoServerApplication app = new GeoServerApplication();
        app.setApplicationContext((ApplicationContext)applicationContext);
        app.setServletContext((ServletContext)new MockServletContext((Application)app, "src"));
        Assert.assertFalse((boolean)SecurityHomePageContentProvider.isEmbeddedDataDirectory((GeoServerApplication)app));
    }

    @Test
    public void testMasterPasswordMessageWithLoginDisabled() throws Exception {
        this.checkMasterPasswordMessage(false);
    }

    @Test
    public void testMasterPasswordMessageWithLoginEnabled() throws Exception {
        this.checkMasterPasswordMessage(true);
    }

    private void checkMasterPasswordMessage(boolean loginEnabled) throws Exception {
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(loginEnabled);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        tester.startComponentInPage(new SecurityHomePageContentProvider().getPageBodyComponent("swp"));
        tester.assertComponent("swp", SecurityHomePageContentProvider.SecurityWarningsPanel.class);
        tester.assertVisible("swp:mpmessage");
        tester.assertVisible("swp:mplink");
    }
}

