/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPDefaultConfiguration;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.csp.CSPRule;
import org.geoserver.security.web.csp.CSPConfigurationPage;
import org.geoserver.security.web.csp.CSPPolicyPage;
import org.geoserver.security.web.csp.CSPPolicyPanel;
import org.geoserver.security.web.csp.CSPRulePage;
import org.geoserver.security.web.csp.CSPRulePanel;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.Icon;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CSPConfigurationPageTest
extends GeoServerWicketTestSupport {
    private static final CSPConfiguration DEFAULT_CONFIG = CSPDefaultConfiguration.newInstance();
    private CSPConfiguration expectedConfig = null;

    @BeforeClass
    public static void setLanguage() {
        Locale.setDefault(Locale.ENGLISH);
    }

    protected void setUpTestData(SystemTestData testData) {
    }

    @Before
    public void startConfigurationPage() throws Exception {
        CSPConfigurationPageTest.getDao().setConfig(CSPConfigurationPageTest.defaultConfig());
        this.login();
        tester.startPage(CSPConfigurationPage.class);
        this.expectedConfig = CSPConfigurationPageTest.defaultConfig();
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, 0);
    }

    @Test
    public void testAddPolicyMissingName() throws Exception {
        tester.clickLink("form:policies:add");
        CSPConfigurationPageTest.assertPolicyPage(new CSPPolicy(), 0);
        tester.newFormTester("form").submit("save");
        tester.assertErrorMessages(new Serializable[]{"Field 'Name' is required."});
    }

    @Test
    public void testAddPolicyDuplicateName() throws Exception {
        String name = ((CSPPolicy)this.expectedConfig.getPolicies().get(0)).getName();
        tester.clickLink("form:policies:add");
        CSPConfigurationPageTest.assertPolicyPage(new CSPPolicy(), 0);
        tester.newFormTester("form").setValue("name", name).submit("save");
        tester.assertErrorMessages(new Serializable[]{"Another policy with the same name already exists: '" + name + "'"});
    }

    @Test
    public void testAddRuleMissingName() throws Exception {
        tester.clickLink("form:policies:add");
        CSPConfigurationPageTest.assertPolicyPage(new CSPPolicy(), 0);
        tester.clickLink("form:rules:add");
        CSPConfigurationPageTest.assertRulePage(new CSPRule());
        tester.newFormTester("form").submit("save");
        tester.assertErrorMessages(new Serializable[]{"Field 'Name' is required."});
    }

    @Test
    public void testAddRuleDuplicateName() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        String name = ((CSPRule)expectedPolicy.getRules().get(0)).getName();
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:add");
        CSPConfigurationPageTest.assertRulePage(new CSPRule());
        tester.newFormTester("form").setValue("name", name).submit("save");
        tester.assertErrorMessages(new Serializable[]{"Another rule with the same name already exists: '" + name + "'"});
    }

    @Test
    public void testEditConfigFieldsAndSave() throws Exception {
        this.expectedConfig.setEnabled(false);
        this.expectedConfig.setInjectProxyBase(true);
        this.expectedConfig.setRemoteResources("http://geoserver.org");
        this.expectedConfig.setFrameAncestors("'self' http://geoserver.org");
        tester.newFormTester("form").setValue("enabled", this.expectedConfig.isEnabled()).setValue("injectProxyBase", this.expectedConfig.isInjectProxyBase()).setValue("remoteResources", this.expectedConfig.getRemoteResources()).setValue("frameAncestors", this.expectedConfig.getFrameAncestors()).submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testEditConfigFieldsAndCancel() throws Exception {
        tester.newFormTester("form").setValue("enabled", false).setValue("injectProxyBase", true).setValue("remoteResources", "http://geoserver.org").setValue("frameAncestors", "'self' http://geoserver.org").submit("cancel");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testEditPolicyFieldsAndSave() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        expectedPolicy.setDescription("foo");
        expectedPolicy.setEnabled(false);
        tester.newFormTester("form").setValue("description", expectedPolicy.getDescription()).setValue("enabled", expectedPolicy.isEnabled()).submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testEditPolicyFieldsAndCancel() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.newFormTester("form").setValue("description", "foo").setValue("enabled", false).submit("cancel");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testEditRuleFieldsAndSave() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        CSPRule expectedRule = (CSPRule)expectedPolicy.getRules().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertRulePage(expectedRule);
        expectedRule.setDescription("foo");
        expectedRule.setEnabled(false);
        expectedRule.setFilter("PATH(^.*$)");
        expectedRule.setDirectives("NONE");
        tester.newFormTester("form").setValue("description", expectedRule.getDescription()).setValue("enabled", expectedRule.isEnabled()).setValue("filter", expectedRule.getFilter()).setValue("directives", expectedRule.getDirectives()).submit("save");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, expectedPolicy.getRules().size());
        tester.newFormTester("form").submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testEditRuleFieldsAndCancel() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        CSPRule expectedRule = (CSPRule)expectedPolicy.getRules().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertRulePage(expectedRule);
        tester.newFormTester("form").setValue("description", "foo").setValue("enabled", false).setValue("filter", "").setValue("directives", "NONE").submit("cancel");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, expectedPolicy.getRules().size());
        tester.newFormTester("form").submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testMovePolicyDown() throws Exception {
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:1:component:down:link");
        this.expectedConfig.getPolicies().add((CSPPolicy)this.expectedConfig.getPolicies().remove(0));
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testMovePolicyUp() throws Exception {
        tester.clickLink("form:policies:table:listContainer:items:2:itemProperties:1:component:up:link");
        this.expectedConfig.getPolicies().add((CSPPolicy)this.expectedConfig.getPolicies().remove(0));
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testRemovePolicy() throws Exception {
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:5:component:link");
        this.expectedConfig.getPolicies().remove(0);
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size() + 1);
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testMoveRuleDown() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:table:listContainer:items:1:itemProperties:1:component:down:link");
        expectedPolicy.getRules().add(0, (CSPRule)expectedPolicy.getRules().remove(1));
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, expectedPolicy.getRules().size());
        tester.newFormTester("form").submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testMoveRuleUp() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:table:listContainer:items:2:itemProperties:1:component:up:link");
        expectedPolicy.getRules().add(0, (CSPRule)expectedPolicy.getRules().remove(1));
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, expectedPolicy.getRules().size());
        tester.newFormTester("form").submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testRemoveRule() throws Exception {
        CSPPolicy expectedPolicy = (CSPPolicy)this.expectedConfig.getPolicies().get(0);
        tester.clickLink("form:policies:table:listContainer:items:1:itemProperties:3:component:link");
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, 0);
        tester.clickLink("form:rules:table:listContainer:items:1:itemProperties:7:component:link");
        expectedPolicy.getRules().remove(0);
        CSPConfigurationPageTest.assertPolicyPage(expectedPolicy, expectedPolicy.getRules().size() + 1);
        tester.newFormTester("form").submit("save");
        CSPConfigurationPageTest.assertConfigPage(this.expectedConfig, this.expectedConfig.getPolicies().size());
        tester.newFormTester("form").submit("save");
        tester.assertNoErrorMessage();
        CSPConfigurationPageTest.assertConfig(this.expectedConfig);
    }

    @Test
    public void testTestEmptyURL() throws Exception {
        tester.newFormTester("form").submit("testLink");
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:testResult", (Object)"Enter URL");
    }

    @Test
    public void testTestBlankURL() throws Exception {
        tester.newFormTester("form").setValue("testUrl", "     ").submit("testLink");
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:testResult", (Object)"Enter URL");
    }

    @Test
    public void testTestInvalidURL() throws Exception {
        tester.newFormTester("form").setValue("testUrl", "~!@#$").submit("testLink");
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        MatcherAssert.assertThat((Object)((Serializable)messages.get(0)), (Matcher)Matchers.instanceOf(MalformedURLException.class));
        tester.assertModelValue("form:testResult", (Object)"ERROR");
    }

    @Test
    public void testTestValidURL() throws Exception {
        tester.newFormTester("form").setValue("testUrl", "http://localhost/geoserver/wms&request=GetCapabilities").submit("testLink");
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:testResult", (Object)"base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';");
    }

    @Test
    public void testTestDisabled() throws Exception {
        tester.newFormTester("form").setValue("enabled", false).setValue("testUrl", "http://localhost/geoserver/wms&request=GetCapabilities").submit("testLink");
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:testResult", (Object)"NONE");
    }

    private static void assertConfigPage(CSPConfiguration config, int offset) {
        CSPConfigurationPageTest.assertConfigPage(config.isEnabled(), config.isReportOnly(), config.isAllowOverride(), config.isInjectProxyBase(), config.getRemoteResources(), config.getFrameAncestors(), config.getPolicies(), offset);
    }

    private static void assertConfigPage(boolean enabled, boolean reportOnly, boolean allowOverride, boolean injectProxyBase, String remoteResources, String frameAncestors, List<CSPPolicy> policies, int offset) {
        tester.assertRenderedPage(CSPConfigurationPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:enabled", (Object)enabled);
        tester.assertModelValue("form:reportOnly", (Object)reportOnly);
        tester.assertModelValue("form:allowOverride", (Object)allowOverride);
        tester.assertModelValue("form:injectProxyBase", (Object)injectProxyBase);
        tester.assertModelValue("form:remoteResources", (Object)remoteResources);
        tester.assertModelValue("form:frameAncestors", (Object)frameAncestors);
        tester.assertComponent("form:policies", CSPPolicyPanel.class);
        tester.assertComponent("form:policies:add", AjaxLink.class);
        Component component = tester.getComponentFromLastRenderedPage("form:policies:table:listContainer:items");
        MatcherAssert.assertThat((Object)component, (Matcher)Matchers.instanceOf(MarkupContainer.class));
        Assert.assertEquals((long)policies.size(), (long)((MarkupContainer)component).size());
        for (int i = 1; i <= policies.size(); ++i) {
            CSPPolicy policy = policies.get(i - 1);
            String path = "form:policies:table:listContainer:items:" + (i + offset) + ":itemProperties:";
            tester.assertLabel(path + "0:component", Integer.toString(i));
            if (policy.isEnabled()) {
                component = tester.getComponentFromLastRenderedPage(path + "2:component");
                MatcherAssert.assertThat((Object)component, (Matcher)Matchers.instanceOf(Icon.class));
            } else {
                tester.assertLabel(path + "2:component", "");
            }
            tester.assertLabel(path + "3:component:link:label", policy.getName());
            tester.assertModelValue(path + "4:component", (Object)policy.getDescription());
        }
        tester.assertModelValue("form:testUrl", (Object)"");
        tester.assertComponent("form:testLink", AjaxSubmitLink.class);
        tester.assertModelValue("form:testResult", (Object)"");
        tester.assertComponent("form:save", SubmitLink.class);
        tester.assertComponent("form:apply", Button.class);
        tester.assertComponent("form:cancel", Button.class);
    }

    private static void assertPolicyPage(CSPPolicy policy, int offset) {
        CSPConfigurationPageTest.assertPolicyPage(policy.getName(), policy.getDescription(), policy.isEnabled(), policy.getRules(), offset);
    }

    private static void assertPolicyPage(String name, String description, boolean enabled, List<CSPRule> rules, int offset) {
        tester.assertRenderedPage(CSPPolicyPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:name", (Object)name);
        if (name == null) {
            tester.assertEnabled("form:name");
        } else {
            tester.assertDisabled("form:name");
        }
        tester.assertModelValue("form:description", (Object)description);
        tester.assertModelValue("form:enabled", (Object)enabled);
        tester.assertComponent("form:rules", CSPRulePanel.class);
        tester.assertComponent("form:rules:add", AjaxLink.class);
        Component component = tester.getComponentFromLastRenderedPage("form:rules:table:listContainer:items");
        MatcherAssert.assertThat((Object)component, (Matcher)Matchers.instanceOf(MarkupContainer.class));
        Assert.assertEquals((long)rules.size(), (long)((MarkupContainer)component).size());
        for (int i = 1; i <= rules.size(); ++i) {
            CSPRule rule = rules.get(i - 1);
            String path = "form:rules:table:listContainer:items:" + (i + offset) + ":itemProperties:";
            tester.assertLabel(path + "0:component", Integer.toString(i));
            if (rule.isEnabled()) {
                component = tester.getComponentFromLastRenderedPage(path + "2:component");
                MatcherAssert.assertThat((Object)component, (Matcher)Matchers.instanceOf(Icon.class));
            } else {
                tester.assertLabel(path + "2:component", "");
            }
            tester.assertLabel(path + "3:component:link:label", rule.getName());
            component = tester.getComponentFromLastRenderedPage(path + "4:component");
            MatcherAssert.assertThat((Object)component, (Matcher)Matchers.instanceOf(Icon.class));
            Assert.assertEquals((Object)rule.getDescription(), (Object)tester.getTagById(component.getMarkupId()).getChild("img").getAttribute("title"));
            tester.assertModelValue(path + "5:component", (Object)rule.getFilter());
            tester.assertModelValue(path + "6:component", (Object)rule.getDirectives());
        }
        tester.assertComponent("form:save", SubmitLink.class);
        tester.assertComponent("form:cancel", Button.class);
    }

    private static void assertRulePage(CSPRule rule) {
        CSPConfigurationPageTest.assertRulePage(rule.getName(), rule.getDescription(), rule.isEnabled(), rule.getFilter(), rule.getDirectives());
    }

    private static void assertRulePage(String name, String description, boolean enabled, String filter, String directives) {
        tester.assertRenderedPage(CSPRulePage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:name", (Object)name);
        if (name == null) {
            tester.assertEnabled("form:name");
        } else {
            tester.assertDisabled("form:name");
        }
        tester.assertModelValue("form:description", (Object)description);
        tester.assertModelValue("form:enabled", (Object)enabled);
        tester.assertModelValue("form:filter", (Object)filter);
        tester.assertModelValue("form:directives", (Object)directives);
        tester.assertComponent("form:save", SubmitLink.class);
        tester.assertComponent("form:cancel", Button.class);
    }

    private static void assertConfig(CSPConfiguration expectedConfig) throws Exception {
        CSPConfigurationPageTest.assertConfig(expectedConfig.isEnabled(), expectedConfig.isInjectProxyBase(), expectedConfig.getRemoteResources(), expectedConfig.getFrameAncestors(), expectedConfig.getPolicies());
    }

    private static void assertConfig(boolean enabled, boolean injectProxyBase, String remoteResources, String frameAncestors, List<CSPPolicy> policies) throws Exception {
        CSPConfiguration actualConfig = CSPConfigurationPageTest.getConfig();
        Assert.assertEquals((Object)enabled, (Object)actualConfig.isEnabled());
        Assert.assertEquals((Object)injectProxyBase, (Object)actualConfig.isInjectProxyBase());
        Assert.assertEquals((Object)remoteResources, (Object)actualConfig.getRemoteResources());
        Assert.assertEquals((Object)frameAncestors, (Object)actualConfig.getFrameAncestors());
        Assert.assertEquals((long)policies.size(), (long)actualConfig.getPolicies().size());
        for (int i = 0; i < policies.size(); ++i) {
            CSPConfigurationPageTest.assertPolicy(policies.get(i), (CSPPolicy)actualConfig.getPolicies().get(i));
        }
    }

    private static void assertPolicy(CSPPolicy expectedPolicy, CSPPolicy actualPolicy) {
        CSPConfigurationPageTest.assertPolicy(actualPolicy, expectedPolicy.getName(), expectedPolicy.getDescription(), expectedPolicy.isEnabled(), expectedPolicy.getRules());
    }

    private static void assertPolicy(CSPPolicy actualPolicy, String name, String description, boolean enabled, List<CSPRule> rules) {
        Assert.assertEquals((Object)name, (Object)actualPolicy.getName());
        Assert.assertEquals((Object)description, (Object)actualPolicy.getDescription());
        Assert.assertEquals((Object)enabled, (Object)actualPolicy.isEnabled());
        Assert.assertEquals((long)rules.size(), (long)actualPolicy.getRules().size());
        for (int i = 0; i < rules.size(); ++i) {
            CSPConfigurationPageTest.assertRule(rules.get(i), (CSPRule)actualPolicy.getRules().get(i));
        }
    }

    private static void assertRule(CSPRule expectedRule, CSPRule actualRule) {
        CSPConfigurationPageTest.assertRule(actualRule, expectedRule.getName(), expectedRule.getDescription(), expectedRule.isEnabled(), expectedRule.getFilter(), expectedRule.getDirectives());
    }

    private static void assertRule(CSPRule actualRule, String name, String description, boolean enabled, String filter, String directives) {
        Assert.assertEquals((Object)name, (Object)actualRule.getName());
        Assert.assertEquals((Object)description, (Object)actualRule.getDescription());
        Assert.assertEquals((Object)enabled, (Object)actualRule.isEnabled());
        Assert.assertEquals((Object)filter, (Object)actualRule.getFilter());
        Assert.assertEquals((Object)directives, (Object)actualRule.getDirectives());
    }

    private static CSPConfiguration defaultConfig() {
        return new CSPConfiguration(DEFAULT_CONFIG);
    }

    private static CSPConfiguration getConfig() throws Exception {
        CSPHeaderDAO dao = CSPConfigurationPageTest.getDao();
        dao.reset();
        return dao.getConfig();
    }

    private static CSPHeaderDAO getDao() {
        return (CSPHeaderDAO)GeoServerExtensions.bean(CSPHeaderDAO.class);
    }
}

