/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.AbstractListPageTest;
import org.geoserver.security.web.data.DataAccessRuleProvider;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.security.web.data.EditDataAccessRulePage;
import org.geoserver.security.web.data.NewDataAccessRulePage;
import org.geoserver.security.web.data.SelectionDataRuleRemovalLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class DataSecurityPageTest
extends AbstractListPageTest<DataAccessRule> {
    @Override
    protected Page listPage(PageParameters params) {
        return new DataSecurityPage();
    }

    @Override
    protected Page newPage(Object ... params) {
        return new NewDataAccessRulePage();
    }

    @Override
    protected Page editPage(Object ... params) {
        if (params.length == 0) {
            return new EditDataAccessRulePage(new DataAccessRule("it.geosolutions", "layer.dots", AccessMode.READ, Collections.singleton("ROLE_ABC")));
        }
        return new EditDataAccessRulePage((DataAccessRule)params[0]);
    }

    @Override
    protected GeoServerDataProvider.Property<DataAccessRule> getEditProperty() {
        return DataAccessRuleProvider.RULEKEY;
    }

    @Override
    protected boolean checkEditForm(String objectString) {
        String[] array = objectString.split("\\.");
        return array[0].equals(tester.getComponentFromLastRenderedPage("form:root").getDefaultModelObject()) && array[1].equals(tester.getComponentFromLastRenderedPage("form:layerContainer:layerAndLabel:layer").getDefaultModelObject());
    }

    @Override
    protected String getSearchString() throws Exception {
        for (DataAccessRule rule : DataAccessRuleDAO.get().getRules()) {
            if (!MockData.CITE_PREFIX.equals(rule.getRoot()) || !MockData.BRIDGES.getLocalPart().equals(rule.getLayer())) continue;
            return rule.getKey();
        }
        return null;
    }

    @Override
    protected void simulateDeleteSubmit() throws Exception {
        DataAccessRuleDAO.get().reload();
        Assert.assertFalse((boolean)DataAccessRuleDAO.get().getRules().isEmpty());
        SelectionDataRuleRemovalLink link = (SelectionDataRuleRemovalLink)this.getRemoveLink();
        Method m = link.delegate.getClass().getDeclaredMethod("onSubmit", AjaxRequestTarget.class, Component.class);
        m.invoke((Object)link.delegate, new Object[]{null, null});
        DataAccessRuleDAO.get().reload();
        Assert.assertEquals((long)2L, (long)DataAccessRuleDAO.get().getRules().size());
    }

    @Test
    public void testDefaultCatalogMode() throws Exception {
        tester.startPage(DataSecurityPage.class);
        tester.assertRenderedPage(DataSecurityPage.class);
        Assert.assertEquals((Object)"HIDE", (Object)tester.getComponentFromLastRenderedPage("otherSettingsForm:catalogMode").getDefaultModelObject().toString());
    }

    @Test
    public void testEditCatalogMode() throws Exception {
        tester.startPage(DataSecurityPage.class);
        tester.assertRenderedPage(DataSecurityPage.class);
        Assert.assertNotEquals((Object)"CHALLENGE", (Object)tester.getComponentFromLastRenderedPage("otherSettingsForm:catalogMode").getDefaultModelObject());
        FormTester form = tester.newFormTester("otherSettingsForm");
        form.select("catalogMode", 1);
        Assert.assertEquals((Object)"MIXED", (Object)tester.getComponentFromLastRenderedPage("otherSettingsForm:catalogMode").getDefaultModelObject().toString());
    }

    @Test
    public void testSandbox() throws Exception {
        File sandbox = new File("./target/sandbox").getCanonicalFile();
        sandbox.mkdirs();
        File notThere = new File("./target/notThere").getCanonicalFile();
        tester.startPage(DataSecurityPage.class);
        tester.assertRenderedPage(DataSecurityPage.class);
        FormTester form = tester.newFormTester("otherSettingsForm");
        form.setValue("sandboxContainer:sandbox:border:border_body:paramValue", notThere.getAbsolutePath());
        form.submit("save");
        tester.assertErrorMessages(new Serializable[]{"The sandbox directory does not exist"});
        tester.clearFeedbackMessages();
        form = tester.newFormTester("otherSettingsForm");
        form.setValue("sandboxContainer:sandbox:border:border_body:paramValue", sandbox.getAbsolutePath());
        form.submit("save");
        tester.assertNoErrorMessage();
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        Assert.assertEquals((Object)sandbox.getAbsolutePath().replace("\\", "/"), (Object)dao.getFilesystemSandbox());
    }
}

