/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.MockData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.security.web.data.NewDataAccessRulePage;
import org.geoserver.security.web.role.NewRolePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewDataAccessRulePageTest
extends AbstractSecurityWicketTestSupport {
    NewDataAccessRulePage page;

    @Before
    public void init() throws Exception {
        this.initializeForXML();
        this.clearServices();
        DataAccessRuleDAO.get().clear();
        DataAccessRuleDAO.get().storeRules();
    }

    @Test
    public void testFillAndSwitchToNewRolePage() throws Exception {
        this.testFill(true);
    }

    @Test
    public void testFill() throws Exception {
        this.testFill(false);
    }

    private void testFill(boolean testSwitchToNewRole) throws IOException {
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.rootChoice.getChoices(), MockData.CITE_PREFIX);
        form.select("root", index);
        tester.executeAjaxEvent("form:root", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.layerChoice.getChoices(), MockData.STREAMS.getLocalPart());
        form.select("layerContainer:layerAndLabel:layer", index);
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.READ);
        form.select("accessMode", index);
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        form = tester.newFormTester("form");
        form.setValue("name", "ROLE_NEW");
        form.submit("save");
        form = tester.newFormTester("form");
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_NEW").getAuthority());
        if (testSwitchToNewRole) {
            form.submit("roles:addRole");
            tester.assertRenderedPage(NewRolePage.class);
            tester.clickLink("form:cancel");
            tester.assertRenderedPage(NewDataAccessRulePage.class);
            form = tester.newFormTester("form", false);
        }
        form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(DataSecurityPage.class);
        DataAccessRule foundRule = null;
        for (DataAccessRule rule : DataAccessRuleDAO.get().getRules()) {
            if (!MockData.CITE_PREFIX.equals(rule.getRoot()) || !MockData.STREAMS.getLocalPart().equals(rule.getLayer()) || !AccessMode.READ.equals((Object)rule.getAccessMode())) continue;
            foundRule = rule;
            break;
        }
        Assert.assertNotNull(foundRule);
        Assert.assertEquals((long)1L, (long)foundRule.getRoles().size());
        Assert.assertEquals((Object)"ROLE_NEW", foundRule.getRoles().iterator().next());
    }

    @Test
    public void testDuplicateRule() throws Exception {
        this.initializeServiceRules();
        this.addRule();
        tester.assertNoErrorMessage();
        this.addRule();
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*" + MockData.CITE_PREFIX + "\\." + MockData.BRIDGES.getLocalPart() + ".*"));
        tester.assertRenderedPage(NewDataAccessRulePage.class);
    }

    private void addRule() {
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.rootChoice.getChoices(), MockData.CITE_PREFIX);
        form.select("root", index);
        tester.executeAjaxEvent("form:root", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.layerChoice.getChoices(), MockData.BRIDGES.getLocalPart());
        form.select("layerContainer:layerAndLabel:layer", index);
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.WRITE);
        form.select("accessMode", index);
        form.setValue("roles:palette:recorder", "ROLE_WMS");
        form.submit("save");
    }

    @Test
    public void testEmptyRoles() throws Exception {
        this.initializeServiceRules();
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.rootChoice.getChoices(), MockData.CITE_PREFIX);
        form.select("root", index);
        tester.executeAjaxEvent("form:root", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.layerChoice.getChoices(), MockData.STREAMS.getLocalPart());
        form.select("layerContainer:layerAndLabel:layer", index);
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.READ);
        form.select("accessMode", index);
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*no role.*"));
        tester.assertRenderedPage(NewDataAccessRulePage.class);
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.activateRORoleService();
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertInvisible("form:roles:addRole");
    }

    @Test
    public void testAddAdminRule() throws Exception {
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.rootChoice.getChoices(), MockData.CITE_PREFIX);
        form.select("root", index);
        tester.executeAjaxEvent("form:root", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.layerChoice.getChoices(), "*");
        form.select("layerContainer:layerAndLabel:layer", index);
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.ADMIN);
        form.select("accessMode", index);
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        form = tester.newFormTester("form");
        form.setValue("name", "ROLE_NEW");
        form.submit("save");
        tester.assertNoErrorMessage();
        form = tester.newFormTester("form");
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_NEW").getAuthority());
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        DataAccessRule rule = new DataAccessRule(MockData.CITE_PREFIX, "*", AccessMode.ADMIN, new String[0]);
        Assert.assertFalse((boolean)dao.getRules().contains(rule));
        form = tester.newFormTester("form");
        form.submit("save");
        dao.reload();
        Assert.assertTrue((boolean)dao.getRules().contains(rule));
    }

    @Test
    public void testAddGlobalLayerGroupRule() throws Exception {
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("globalGroupRule", true);
        tester.executeAjaxEvent("form:globalGroupRule", "change");
        form.setValue("globalGroupRule", true);
        int index = this.indexOf(this.page.rootChoice.getChoices(), "nature");
        form.select("root", index);
        tester.assertInvisible("form:layerContainer:layerAndLabel");
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.READ);
        form.select("accessMode", index);
        form.setValue("roles:anyRole", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        DataAccessRule rule = new DataAccessRule("nature", null, AccessMode.READ, new String[0]);
        List rules = dao.getRules();
        Assert.assertTrue((boolean)rules.contains(rule));
    }

    @Test
    public void testWorkspaceGlobalLayerGroupRule() throws Exception {
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.rootChoice.getChoices(), MockData.CITE_PREFIX);
        form.select("root", index);
        tester.executeAjaxEvent("form:root", "change");
        form.setValue("roles:anyRole", true);
        tester.executeAjaxEvent("form:roles:anyRole", "click");
        form.select("root", index);
        index = this.indexOf(this.page.layerChoice.getChoices(), "citeNature");
        Assert.assertNotEquals((long)-1L, (long)index);
        form.select("layerContainer:layerAndLabel:layer", index);
        index = this.page.accessModeChoice.getChoices().indexOf(AccessMode.READ);
        form.select("accessMode", index);
        form.setValue("roles:anyRole", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        DataAccessRule rule = new DataAccessRule(MockData.CITE_PREFIX, "citeNature", AccessMode.READ, new String[0]);
        List rules = dao.getRules();
        Assert.assertTrue((boolean)rules.contains(rule));
    }

    protected int indexOf(List<? extends String> strings, String searchValue) {
        int index = 0;
        for (String string : strings) {
            if (string.equals(searchValue)) {
                return index;
            }
            ++index;
        }
        Assert.assertNotEquals((long)index, (long)-1L);
        return -1;
    }
}

