/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.lang.reflect.Method;
import java.util.List;
import java.util.SortedSet;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractTabbedListPageTest;
import org.geoserver.security.web.role.EditRolePage;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.role.RoleListProvider;
import org.geoserver.security.web.role.SelectionRoleRemovalLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Test;

public class RoleListPageTest
extends AbstractTabbedListPageTest<GeoServerRole> {
    public static final String SECOND_COLUM_PATH = "itemProperties:1:component:link";

    @Override
    protected String getServiceName() {
        return this.getRoleServiceName();
    }

    protected AbstractSecurityPage listPage(String roleServiceName) {
        AbstractSecurityPage result = this.initializeForRoleServiceNamed(roleServiceName);
        tester.clickLink(this.getTabbedPanelPath() + ":tabs-container:tabs:1:link", true);
        return result;
    }

    @Override
    protected Page newPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new NewRolePage(this.getSecurityManager().getActiveRoleService().getName()).setReturnPage((Page)page);
        }
        return new NewRolePage((String)params[0]).setReturnPage((Page)page);
    }

    @Override
    protected Page editPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new EditRolePage(this.getSecurityManager().getActiveRoleService().getName(), GeoServerRole.ADMIN_ROLE).setReturnPage((Page)page);
        }
        if (params.length == 1) {
            return new EditRolePage(this.getSecurityManager().getActiveRoleService().getName(), (GeoServerRole)params[0]).setReturnPage((Page)page);
        }
        return new EditRolePage((String)params[0], (GeoServerRole)params[1]).setReturnPage((Page)page);
    }

    @Override
    protected String getTabbedPanelPath() {
        return "panel:panel";
    }

    @Override
    protected String getItemsPath() {
        return this.getTabbedPanelPath() + ":panel:table:listContainer:items";
    }

    @Test
    public void testEditParentRole() throws Exception {
        tester.startPage((Page)this.listPage(this.getRoleServiceName()));
        GeoServerRole role = this.gaService.getRoleByName("ROLE_AUTHENTICATED");
        Assert.assertNotNull((Object)role);
        List props = new RoleListProvider(this.getRoleServiceName()).getProperties();
        GeoServerDataProvider.Property parentProp = null;
        for (GeoServerDataProvider.Property prop : props) {
            if (!"parentrolename".equals(prop.getName())) continue;
            parentProp = prop;
            break;
        }
        Component c = this.getFromList(SECOND_COLUM_PATH, role, parentProp);
        Assert.assertNotNull((Object)c);
        tester.clickLink(c.getPageRelativePath());
        tester.assertRenderedPage(EditRolePage.class);
        Assert.assertTrue((boolean)this.checkEditForm(role.getAuthority()));
    }

    @Override
    protected String getSearchString() throws Exception {
        GeoServerRole role = this.gaService.getRoleByName(GeoServerRole.ADMIN_ROLE.getAuthority());
        Assert.assertNotNull((Object)role);
        return role.getAuthority();
    }

    @Override
    protected GeoServerDataProvider.Property<GeoServerRole> getEditProperty() {
        return RoleListProvider.ROLENAME;
    }

    @Override
    protected boolean checkEditForm(String objectString) {
        return objectString.equals(tester.getComponentFromLastRenderedPage("form:name").getDefaultModelObject());
    }

    @Test
    public void testReadOnlyService() throws Exception {
        this.listPage(this.getRoleServiceName());
        tester.assertVisible(this.getRemoveLink().getPageRelativePath());
        tester.assertVisible(this.getAddLink().getPageRelativePath());
        this.activateRORoleService();
        this.listPage(this.getRORoleServiceName());
        tester.assertInvisible(this.getRemoveLink().getPageRelativePath());
        tester.assertInvisible(this.getAddLink().getPageRelativePath());
    }

    @Override
    protected void simulateDeleteSubmit() throws Exception {
        SelectionRoleRemovalLink link = (SelectionRoleRemovalLink)this.getRemoveLink();
        Method m = link.delegate.getClass().getDeclaredMethod("onSubmit", AjaxRequestTarget.class, Component.class);
        m.invoke((Object)link.delegate, new Object[]{null, null});
        SortedSet roles = this.gaService.getRoles();
        Assert.assertEquals((long)3L, (long)roles.size());
        Assert.assertFalse((boolean)roles.contains(this.createNewRoleForRemvovalTest()));
    }

    GeoServerRole createNewRoleForRemvovalTest() throws Exception {
        return this.gaStore.createRoleObject("NEW_ROLE");
    }

    @Override
    protected void doRemove(String pathForLink) throws Exception {
        GeoServerRole newRole = this.createNewRoleForRemvovalTest();
        this.gaStore.addRole(newRole);
        this.gaStore.store();
        Assert.assertEquals((long)5L, (long)this.gaService.getRoles().size());
        super.doRemove(pathForLink);
    }
}

