/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.data.ConfirmRemovalDataAccessRulePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;

public class SelectionDataRuleRemovalLink
extends AjaxLink<Object> {
    static final Logger LOGGER = Logging.getLogger(SelectionDataRuleRemovalLink.class);
    GeoServerTablePanel<DataAccessRule> rules;
    GeoServerDialog dialog;
    ConfirmRemovalDataAccessRulePanel removePanel;
    GeoServerDialog.DialogDelegate delegate;

    public SelectionDataRuleRemovalLink(String id, GeoServerTablePanel<DataAccessRule> rules, GeoServerDialog dialog) {
        super(id);
        this.rules = rules;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.rules.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.delegate = new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                SelectionDataRuleRemovalLink.this.removePanel = new ConfirmRemovalDataAccessRulePanel(id, selection){

                    @Override
                    protected IModel<String> canRemove(DataAccessRule data) {
                        return SelectionDataRuleRemovalLink.this.canRemove(data);
                    }
                };
                return SelectionDataRuleRemovalLink.this.removePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                DataAccessRuleDAO dao = DataAccessRuleDAO.get();
                for (DataAccessRule rule : SelectionDataRuleRemovalLink.this.removePanel.getRoots()) {
                    dao.removeRule((Comparable)rule);
                }
                try {
                    dao.storeRules();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
                SelectionDataRuleRemovalLink.this.rules.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionDataRuleRemovalLink.this.rules.getSelection().isEmpty()) {
                    SelectionDataRuleRemovalLink.this.setEnabled(false);
                    target.add(new Component[]{SelectionDataRuleRemovalLink.this});
                    target.add(new Component[]{SelectionDataRuleRemovalLink.this.rules});
                }
            }
        };
        this.dialog.showOkCancel(target, this.delegate);
    }

    protected StringResourceModel canRemove(DataAccessRule data) {
        return null;
    }
}

