/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.url;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.GeoServerURLChecker;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.security.web.url.RegexCheckPage;
import org.geoserver.security.web.url.URLCheckProvider;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckers;
import org.geotools.util.logging.Logging;

public class URLChecksPage
extends GeoServerSecuredPage {
    static final Logger LOGGER = Logging.getLogger(URLChecksPage.class);
    GeoServerDialog dialog;
    AjaxLink<Void> removal;
    AjaxCheckBox service;
    Label statusLabel;
    GeoServerTablePanel<AbstractURLCheck> table;
    private static final long serialVersionUID = 5963434654817570467L;

    public URLChecksPage() throws Exception {
        URLCheckDAO dao = this.getUrlCheckDAO();
        URLCheckProvider provider = new URLCheckProvider(dao.getChecks());
        this.table = new GeoServerTablePanel<AbstractURLCheck>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel<AbstractURLCheck> itemModel, GeoServerDataProvider.Property<AbstractURLCheck> property) {
                if (property == URLCheckProvider.NAME) {
                    return URLChecksPage.this.urlEntryPageLink(id, itemModel);
                }
                if (property == URLCheckProvider.DESCRIPTION) {
                    return new Label(id, (Serializable)((Object)((AbstractURLCheck)itemModel.getObject()).getDescription()));
                }
                if (property == URLCheckProvider.ENABLED) {
                    if (((AbstractURLCheck)itemModel.getObject()).isEnabled()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                if (property == URLCheckProvider.CONFIGURATION) {
                    return new Label(id, (Serializable)((Object)((AbstractURLCheck)itemModel.getObject()).getConfiguration()));
                }
                return null;
            }
        };
        this.table.setPageable(false);
        this.table.setSortable(false);
        this.table.setFilterable(false);
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Form form = new Form("testForm");
        this.add(new Component[]{form});
        final TextArea testInput = new TextArea("testInput", (IModel)new Model());
        testInput.setOutputMarkupId(true);
        form.add(new Component[]{testInput});
        form.add(new Component[]{new AjaxSubmitLink("testURL"){

            public void onSubmit(AjaxRequestTarget target) {
                try {
                    testInput.processInput();
                    URLChecker check = this.getMatchingRule();
                    if (check != null) {
                        String msg = URLChecksPage.this.getMessage("testSuccess", check.getName());
                        this.info((Serializable)((Object)msg));
                    } else {
                        String msg = URLChecksPage.this.getMessage("testFail", new Object[0]);
                        this.error((Serializable)((Object)msg));
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Test failed", e);
                    this.error((Serializable)((Object)("Test failed: " + e.getMessage())));
                }
                URLChecksPage.this.addFeedbackPanels(target);
            }

            private URLChecker getMatchingRule() throws IOException {
                String test = testInput.getInput();
                String normalize = URLCheckers.normalize((String)test);
                ArrayList checks = new ArrayList();
                checks.addAll(URLChecksPage.this.getUrlCheckDAO().getChecks());
                checks.addAll(URLCheckers.getEnabledURLCheckers().stream().filter(item -> !(item instanceof GeoServerURLChecker)).collect(Collectors.toList()));
                for (URLChecker check : checks) {
                    if (!check.isEnabled() || !check.confirm(normalize)) continue;
                    return check;
                }
                return null;
            }
        }});
        this.add(new Component[]{new BookmarkablePageLink("addNew", RegexCheckPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = this.removeSelectedLink("removeSelected");
        componentArray[0] = this.removal;
        this.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(true);
        Component[] componentArray2 = new Component[1];
        this.service = this.getEnabledCheckbox("checksEnabled", (IModel<Boolean>)new ChecksEnabledModel());
        componentArray2[0] = this.service;
        this.add(componentArray2);
        this.service.setOutputMarkupId(true);
        this.service.setEnabled(true);
        Component[] componentArray3 = new Component[1];
        this.statusLabel = new Label("statusLabel", (Serializable)((Object)this.getServiceStatusMessage(dao.isEnabled())));
        componentArray3[0] = this.statusLabel;
        this.add(componentArray3);
        this.statusLabel.setOutputMarkupId(true);
        Component[] componentArray4 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray4[0] = this.dialog;
        this.add(componentArray4);
        this.dialog.setInitialWidth(360);
        this.dialog.setInitialHeight(180);
    }

    Component urlEntryPageLink(String id, IModel<AbstractURLCheck> itemModel) {
        if (itemModel.getObject() instanceof RegexURLCheck) {
            IModel nameModel = URLCheckProvider.NAME.getModel(itemModel);
            return new SimpleBookmarkableLink(id, RegexCheckPage.class, nameModel, new String[]{"name", (String)nameModel.getObject()});
        }
        throw new IllegalArgumentException("Unknown URL check type: " + ((AbstractURLCheck)itemModel.getObject()).getClass().getName());
    }

    private AjaxLink<Void> removeSelectedLink(String id) {
        return new AjaxLink<Void>(id){

            public void onClick(AjaxRequestTarget target) {
                URLChecksPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmDeleteTitle", (Component)URLChecksPage.this, new Object[0]));
                URLChecksPage.this.dialog.setDefaultModel(this.getDefaultModel());
                URLChecksPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 1L;

                    protected Component getContents(String id) {
                        Label confirmLabel = new Label(id, (IModel)new ParamResourceModel("confirmDeleteMessage", (Component)URLChecksPage.this, new Object[]{URLChecksPage.this.table.getSelection().size()}));
                        confirmLabel.setEscapeModelStrings(false);
                        return confirmLabel;
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        URLCheckDAO dao = URLChecksPage.this.getUrlCheckDAO();
                        if (URLChecksPage.this.table.getSelection().isEmpty()) {
                            this.info((Serializable)((Object)"Nothing Selected"));
                            return false;
                        }
                        try {
                            List selection = URLChecksPage.this.table.getSelection();
                            List checks = dao.getChecks();
                            checks.removeAll(selection);
                            dao.saveChecks(checks);
                        }
                        catch (Exception e) {
                            this.error((Serializable)((Object)"An Error while deleting URL entries"));
                            LOGGER.log(Level.SEVERE, "An Error while deleting URL entries", e);
                        }
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        URLChecksPage.this.table.clearSelection();
                        target.add(new Component[]{URLChecksPage.this.table});
                        this.setResponsePage((IRequestablePage)this.getPage());
                    }
                });
            }
        };
    }

    private URLCheckDAO getUrlCheckDAO() {
        return (URLCheckDAO)this.getGeoServerApplication().getBeanOfType(URLCheckDAO.class);
    }

    private AjaxCheckBox getEnabledCheckbox(String id, IModel<Boolean> model) {
        return new AjaxCheckBox(id, model){

            protected void onUpdate(AjaxRequestTarget target) {
                URLChecksPage.this.toggleState(target);
            }
        };
    }

    private void toggleState(AjaxRequestTarget target) {
        boolean enabled;
        try {
            enabled = this.getUrlCheckDAO().isEnabled();
        }
        catch (Exception e) {
            this.error((Serializable)((Object)e.getMessage()));
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        String title = enabled ? "confirmDisableTitle" : "confirmEnableTitle";
        final String message = enabled ? "confirmDisableMessage" : "confirmEnableMessage";
        this.dialog.setTitle((IModel)new ParamResourceModel(title, (Component)this, new Object[0]));
        this.dialog.setDefaultModel(this.getDefaultModel());
        this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
            private static final long serialVersionUID = 1L;

            protected Component getContents(String id) {
                Label confirmLabel = new Label(id, (IModel)new ParamResourceModel(message, (Component)URLChecksPage.this, new Object[0]));
                confirmLabel.setEscapeModelStrings(false);
                return confirmLabel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                try {
                    URLChecksPage.this.getUrlCheckDAO().setEnabled(!enabled);
                    URLChecksPage.this.statusLabel.setDefaultModelObject((Object)URLChecksPage.this.getServiceStatusMessage(URLChecksPage.this.getUrlCheckDAO().isEnabled()));
                    target.add(new Component[]{URLChecksPage.this.statusLabel});
                }
                catch (Exception e) {
                    URLChecksPage.this.error((Serializable)((Object)e.getMessage()));
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                return true;
            }
        });
    }

    private String getServiceStatusMessage(boolean isEnabled) {
        if (isEnabled) {
            return this.getMessage("checksEnabled", new Object[0]);
        }
        return this.getMessage("checksDisabled", new Object[0]);
    }

    private String getMessage(String key, Object ... params) {
        return new ParamResourceModel(key, (Component)this, params).getString();
    }

    private class ChecksEnabledModel
    extends LoadableDetachableModel<Boolean> {
        private ChecksEnabledModel() {
        }

        protected Boolean load() {
            try {
                return URLChecksPage.this.getUrlCheckDAO().isEnabled();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

