/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.Serializable;
import java.util.SortedSet;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.group.NewGroupPage;
import org.geoserver.security.web.role.NewRolePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewGroupPageTest
extends AbstractSecurityWicketTestSupport {
    NewGroupPage page;

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (NewGroupPage)new NewGroupPage(this.getUserGroupServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewGroupPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("groupname", "testgroup");
        Assert.assertTrue((boolean)((GeoServerUserGroup)this.page.get("form").getDefaultModelObject()).isEnabled());
        form.setValue("enabled", false);
        Assert.assertTrue((boolean)this.page.rolePalette.isEnabled());
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        form = tester.newFormTester("form");
        form.setValue("name", "ROLE_NEW");
        form.submit("save");
        form = tester.newFormTester("form");
        tester.assertRenderedPage(NewGroupPage.class);
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_NEW").getAuthority());
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(NewGroupPage.class);
        form = tester.newFormTester("form");
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[0]);
        GeoServerUserGroup group = this.ugService.getGroupByGroupname("testgroup");
        Assert.assertNotNull((Object)group);
        Assert.assertFalse((boolean)group.isEnabled());
        SortedSet roleList = this.gaService.getRolesForGroup("testgroup");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertEquals((Object)"ROLE_NEW", (Object)((GeoServerRole)roleList.iterator().next()).getAuthority());
    }

    @Test
    public void testGroupNameConflict() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (NewGroupPage)new NewGroupPage(this.getUserGroupServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        form.setValue("groupname", "group1");
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*group1.*"));
        tester.getMessages(400);
        tester.assertRenderedPage(NewGroupPage.class);
    }

    @Test
    public void testInvalidWorkflow() throws Exception {
        this.activateROUGService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        boolean fail = true;
        try {
            this.page = (NewGroupPage)new NewGroupPage(this.getROUserGroupServiceName()).setReturnPage((Page)returnPage);
            tester.startPage((Page)this.page);
        }
        catch (RuntimeException ex) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No runtime exception for read only UserGroupService");
        }
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (NewGroupPage)new NewGroupPage(this.getUserGroupServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        Assert.assertFalse((boolean)this.page.rolePalette.isEnabled());
        FormTester form = tester.newFormTester("form");
        form.setValue("groupname", "testgroup");
        form.submit("save");
        GeoServerUserGroup group = this.ugService.getGroupByGroupname("testgroup");
        Assert.assertNotNull((Object)group);
        Assert.assertTrue((boolean)group.isEnabled());
        SortedSet roleList = this.gaService.getRolesForGroup("testgroup");
        Assert.assertEquals((long)0L, (long)roleList.size());
    }
}

