/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.web.csp.CSPRulePanel;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CSPPolicyPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -5200150783568375701L;
    private TextField<String> nameField;
    private CSPConfiguration config;
    private CSPPolicy policy;

    public CSPPolicyPage(CSPPolicy policy, CSPConfiguration config) {
        this.config = config;
        this.policy = new CSPPolicy(policy);
        Model model = new Model((Serializable)this.policy);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((IModel)model));
        this.nameField = new TextField("name", (IModel)new PropertyModel((Object)model, "name"));
        this.nameField.add((IValidator)new NameValidator());
        form.add(new Component[]{this.nameField.setRequired(true).setEnabled(this.policy.getName() == null)});
        form.add(new Component[]{new TextArea("description", (IModel)new PropertyModel((Object)model, "description"))});
        form.add(new Component[]{new CheckBox("enabled", (IModel)new PropertyModel((Object)model, "enabled"))});
        form.add(new Component[]{new CSPRulePanel("rules", this.policy)});
        form.add(new Component[]{new SubmitLink("save", form){
            private static final long serialVersionUID = -5897975410833363747L;

            public void onSubmit() {
                CSPPolicyPage.this.savePolicy();
            }
        }});
        form.add(new Component[]{new Button("cancel"){
            private static final long serialVersionUID = 4579381111420468326L;

            public void onSubmit() {
                CSPPolicyPage.this.doReturn();
            }
        }});
        this.add(new Component[]{form});
    }

    private void savePolicy() {
        List policies = this.config.getPolicies();
        if (this.nameField.isEnabled()) {
            policies.add(new CSPPolicy(this.policy));
        } else {
            for (int i = 0; i < policies.size(); ++i) {
                if (!((CSPPolicy)policies.get(i)).getName().equals(this.policy.getName())) continue;
                policies.set(i, new CSPPolicy(this.policy));
                break;
            }
        }
        this.doReturn();
    }

    private class NameValidator
    implements IValidator<String> {
        private static final long serialVersionUID = 2516642715001094366L;

        private NameValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String name = (String)validatable.getValue();
            if (CSPPolicyPage.this.nameField.isEnabled() && CSPPolicyPage.this.config.getPolicyByName(name) != null) {
                ParamResourceModel message = new ParamResourceModel("duplicatePolicy", (Component)CSPPolicyPage.this, new Object[]{name});
                validatable.error((IValidationError)new ValidationError(message.getString()));
            }
        }
    }
}

