/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.group.AbstractGroupPage;

public class NewGroupPage
extends AbstractGroupPage {
    public NewGroupPage(String userGroupServiceName) {
        super(userGroupServiceName, new GeoServerUserGroup(""));
        if (!this.hasUserGroupStore(userGroupServiceName)) {
            throw new IllegalStateException("New group not possible for read only service");
        }
    }

    @Override
    protected void onFormSubmit(GeoServerUserGroup group) throws IOException {
        UserGroupStoreValidationWrapper store = null;
        try {
            store = new UserGroupStoreValidationWrapper(this.getUserGroupStore(this.userGroupServiceName));
            group = store.createGroupObject(group.getGroupname(), group.isEnabled());
            store.addGroup(group);
            store.store();
        }
        catch (IOException ex) {
            try {
                if (store != null) {
                    store.load();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        GeoServerRoleStore gaStore = null;
        try {
            if (this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName())) {
                gaStore = this.getRoleStore(this.getSecurityManager().getActiveRoleService().getName());
                gaStore = new RoleStoreValidationWrapper(gaStore, new GeoServerUserGroupService[0]);
                for (GeoServerRole role : this.rolePalette.getSelectedRoles()) {
                    gaStore.associateRoleToGroup(role, group.getGroupname());
                }
                gaStore.store();
            }
        }
        catch (IOException ex) {
            try {
                if (gaStore != null) {
                    gaStore.load();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }
}

