/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.web.GeoServerApplication;

public class RoleServiceConfigListModel
extends LoadableDetachableModel<List<SecurityRoleServiceConfig>> {
    protected List<SecurityRoleServiceConfig> load() {
        GeoServerSecurityManager secMgr = GeoServerApplication.get().getSecurityManager();
        ArrayList<SecurityRoleServiceConfig> configs = new ArrayList<SecurityRoleServiceConfig>();
        try {
            for (String roleServiceName : secMgr.listRoleServices()) {
                SecurityRoleServiceConfig config = secMgr.loadRoleServiceConfig(roleServiceName);
                configs.add(config);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return configs;
    }
}

