/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.web.GeoServerApplication;

public class PasswordEncoderChoice
extends DropDownChoice<String> {
    public PasswordEncoderChoice(String id) {
        super(id, (IModel)new PasswordEncoderNamesModel(), (IChoiceRenderer)new PasswordEncoderChoiceRenderer());
    }

    public PasswordEncoderChoice(String id, IModel<String> model) {
        super(id, model, (IModel)new PasswordEncoderNamesModel(), (IChoiceRenderer)new PasswordEncoderChoiceRenderer());
    }

    public PasswordEncoderChoice(String id, List<GeoServerPasswordEncoder> encoders) {
        super(id, (IModel)new PasswordEncoderNamesModel(encoders), (IChoiceRenderer)new PasswordEncoderChoiceRenderer());
    }

    public PasswordEncoderChoice(String id, IModel<String> model, List<GeoServerPasswordEncoder> encoders) {
        super(id, model, (IModel)new PasswordEncoderNamesModel(encoders), (IChoiceRenderer)new PasswordEncoderChoiceRenderer());
    }

    static class PasswordEncoderChoiceRenderer
    extends ChoiceRenderer<String> {
        PasswordEncoderChoiceRenderer() {
        }

        public Object getDisplayValue(String object) {
            return new ResourceModel(object, object).getObject();
        }

        public String getIdValue(String object, int index) {
            return object;
        }
    }

    static class PasswordEncoderNamesModel
    implements IModel<List<String>> {
        List<String> encoderNames = new ArrayList<String>();

        PasswordEncoderNamesModel() {
            this(GeoServerApplication.get().getSecurityManager().loadPasswordEncoders());
        }

        PasswordEncoderNamesModel(List<GeoServerPasswordEncoder> encoders) {
            for (GeoServerPasswordEncoder pe : encoders) {
                this.encoderNames.add(pe.getName());
            }
        }

        public List<String> getObject() {
            return this.encoderNames;
        }

        public void setObject(List<String> object) {
            throw new UnsupportedOperationException();
        }
    }
}

