/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.jdbc;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geoserver.security.jdbc.config.JDBCUserGroupServiceConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.jdbc.JDBCConnectionPanel;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.junit.Assert;
import org.junit.Test;

public class JDBCConnectionPanelTest
extends AbstractSecurityWicketTestSupport {
    JDBCConnectionPanel<JDBCSecurityServiceConfig> current;
    String relBase = "panel:cxPanelContainer:cxPanel:";
    String base = "form:" + this.relBase;
    JDBCSecurityServiceConfig config;

    protected void setupPanel(boolean jndi) {
        this.config = new JDBCUserGroupServiceConfig();
        this.config.setJndi(jndi);
        this.setupPanel(this.config);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setEncryptingUrlParams(false);
        this.getSecurityManager().saveSecurityConfig(config);
    }

    protected void setupPanel(JDBCSecurityServiceConfig theConfig) {
        this.config = theConfig;
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                JDBCConnectionPanelTest.this.current = new JDBCConnectionPanel(id, (IModel)new Model((Serializable)JDBCConnectionPanelTest.this.config));
                return JDBCConnectionPanelTest.this.current;
            }
        }, (IModel)new CompoundPropertyModel((Object)this.config)));
    }

    @Test
    public void testJNDI() throws Exception {
        this.setupPanel(true);
        tester.assertRenderedPage(FormTestPage.class);
        Assert.assertTrue((boolean)this.config.isJndi());
        this.assertVisibility(true);
        FormTester ftester = tester.newFormTester("form");
        ftester.setValue(this.relBase + "jndiName", "jndiurl");
        ftester.submit();
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)"jndiurl", (Object)this.config.getJndiName());
    }

    @Test
    public void testConnectionTestJNDI() throws Exception {
        JDBCUserGroupServiceConfig theConfig = new JDBCUserGroupServiceConfig();
        theConfig.setJndi(true);
        theConfig.setJndiName("jndiurl");
        this.setupPanel((JDBCSecurityServiceConfig)theConfig);
        tester.assertRenderedPage(FormTestPage.class);
        tester.clickLink("form:panel:cxTest", true);
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
    }

    @Test
    public void testBasic() throws Exception {
        this.setupPanel(false);
        tester.assertRenderedPage(FormTestPage.class);
        Assert.assertFalse((boolean)this.config.isJndi());
        this.assertVisibility(false);
        FormTester ftester = tester.newFormTester("form");
        ftester.setValue(this.relBase + "userName", "user1");
        ftester.setValue(this.relBase + "password", "pw");
        ftester.setValue(this.relBase + "driverClassName", "org.h2.Driver");
        ftester.setValue(this.relBase + "connectURL", "jdbc:h2");
        ftester.submit();
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)"user1", (Object)this.config.getUserName());
        Assert.assertEquals((Object)"pw", (Object)this.config.getPassword());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)this.config.getDriverClassName());
        Assert.assertEquals((Object)"jdbc:h2", (Object)this.config.getConnectURL());
    }

    @Test
    public void testConncetionTestBasic() throws Exception {
        JDBCUserGroupServiceConfig theConfig = new JDBCUserGroupServiceConfig();
        theConfig.setUserName("user1");
        theConfig.setPassword("pw");
        theConfig.setDriverClassName("org.h2.Driver");
        theConfig.setConnectURL("jdbc:foo");
        this.setupPanel((JDBCSecurityServiceConfig)theConfig);
        tester.assertRenderedPage(FormTestPage.class);
        tester.clickLink("form:panel:cxTest", true);
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
    }

    @Test
    public void testConnectionTestBasicOK() throws Exception {
        JDBCUserGroupServiceConfig theConfig = new JDBCUserGroupServiceConfig();
        theConfig.setUserName("user1");
        theConfig.setPassword("pw");
        theConfig.setDriverClassName("org.h2.Driver");
        theConfig.setConnectURL("jdbc:h2:file:target/db");
        this.setupPanel((JDBCSecurityServiceConfig)theConfig);
        tester.assertRenderedPage(FormTestPage.class);
        tester.clickLink("form:panel:cxTest", true);
        Assert.assertEquals((long)1L, (long)tester.getMessages(200).size());
    }

    protected void assertVisibility(boolean jndi) {
        if (jndi) {
            tester.assertComponent(this.base + "jndiName", TextField.class);
            tester.assertVisible(this.base + "jndiName");
        } else {
            for (String c : Arrays.asList("driverClassName", "connectURL", "userName", "password")) {
                tester.assertComponent(this.base + c, FormComponent.class);
                tester.assertVisible(this.base + c);
            }
        }
    }
}

