/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPUserGroupServiceConfig;
import org.geoserver.security.web.usergroup.UserGroupServicePanel;

public class LDAPUserGroupServicePanel
extends UserGroupServicePanel<LDAPUserGroupServiceConfig> {
    private static final long serialVersionUID = -5052166946618920800L;
    private static final String USE_NESTED_PARENT_GROUPS = "useNestedParentGroups";
    private static final String MAX_GROUP_SEARCH_LEVEL = "maxGroupSearchLevel";
    private static final String NESTED_GROUP_SEARCH_FILTER = "nestedGroupSearchFilter";
    private static final String NESTED_SEARCH_FIELDS_CONTAINER = "nestedSearchFieldsContainer";

    public LDAPUserGroupServicePanel(String id, IModel<LDAPUserGroupServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("groupSearchBase").setRequired(true)});
        this.add(new Component[]{new TextField("groupNameAttribute")});
        this.add(new Component[]{new TextField("groupFilter")});
        this.add(new Component[]{new TextField("allGroupsSearchFilter")});
        this.add(new Component[]{new TextField("groupSearchFilter")});
        this.add(new Component[]{new TextField("groupMembershipAttribute")});
        this.add(new Component[]{new TextField("userSearchBase").setRequired(true)});
        this.add(new Component[]{new TextField("userNameAttribute")});
        this.add(new Component[]{new TextField("userFilter")});
        this.add(new Component[]{new TextField("allUsersSearchFilter")});
        this.add(new Component[]{new TextField("populatedAttributes")});
        this.hierarchicalGroupsInit();
        this.add(new Component[]{new AjaxCheckBox("bindBeforeGroupSearch"){
            private static final long serialVersionUID = -6388847010436939988L;

            protected void onUpdate(AjaxRequestTarget target) {
                LDAPAuthenticationPanel ldapAuthenticationPanel = (LDAPAuthenticationPanel)LDAPUserGroupServicePanel.this.get("authenticationPanel");
                ldapAuthenticationPanel.resetModel();
                ldapAuthenticationPanel.setVisible((Boolean)this.getModelObject());
                target.add(new Component[]{ldapAuthenticationPanel});
            }
        }});
        LDAPAuthenticationPanel authPanel = new LDAPAuthenticationPanel("authenticationPanel");
        authPanel.setVisible(((LDAPUserGroupServiceConfig)model.getObject()).isBindBeforeGroupSearch());
        authPanel.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{authPanel});
    }

    private void hierarchicalGroupsInit() {
        final WebMarkupContainer nestedSearchFieldsContainer = new WebMarkupContainer(NESTED_SEARCH_FIELDS_CONTAINER);
        nestedSearchFieldsContainer.setOutputMarkupPlaceholderTag(true);
        nestedSearchFieldsContainer.setOutputMarkupId(true);
        this.add(new Component[]{nestedSearchFieldsContainer});
        Optional<LDAPUserGroupServiceConfig> useNestedOpt = Optional.of(this).map(x -> x.configModel).map(IModel::getObject);
        boolean useNestedActivated = useNestedOpt.map(LDAPBaseSecurityServiceConfig::isUseNestedParentGroups).orElse(false);
        nestedSearchFieldsContainer.setVisible(useNestedActivated);
        AjaxCheckBox useNestedCheckbox = new AjaxCheckBox(USE_NESTED_PARENT_GROUPS){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                AjaxCheckBox cb = (AjaxCheckBox)LDAPUserGroupServicePanel.this.get(LDAPUserGroupServicePanel.USE_NESTED_PARENT_GROUPS);
                boolean value = (Boolean)cb.getModelObject();
                nestedSearchFieldsContainer.setVisible(value);
                target.add(new Component[]{nestedSearchFieldsContainer});
            }
        };
        this.add(new Component[]{useNestedCheckbox});
        nestedSearchFieldsContainer.add(new Component[]{new TextField(MAX_GROUP_SEARCH_LEVEL)});
        nestedSearchFieldsContainer.add(new Component[]{new TextField(NESTED_GROUP_SEARCH_FILTER)});
    }

    class LDAPAuthenticationPanel
    extends WebMarkupContainer {
        private static final long serialVersionUID = 6533128678666053350L;

        public LDAPAuthenticationPanel(String id) {
            super(id);
            this.add(new Component[]{new TextField("user")});
            PasswordTextField pwdField = new PasswordTextField("password");
            pwdField.setResetPassword(false);
            this.add(new Component[]{pwdField});
        }

        public void resetModel() {
            this.get("user").setDefaultModelObject(null);
            this.get("password").setDefaultModelObject(null);
        }
    }
}

