/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.MapModel;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.security.ldap.LDAPAuthProviderPanel;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;

@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
@ApplyLdifFiles(value={"data.ldif"})
public class LDAPAuthProviderPanelTest
extends AbstractSecurityWicketTestSupport {
    private static final String USER_FORMAT = "uid={0},ou=People,dc=example,dc=com";
    private static final String USER_FILTER = "(telephonenumber=1)";
    private static final String USER_DN_PATTERN = "uid={0},ou=People";
    LDAPAuthProviderPanel current;
    String relBase = "panel:";
    String base = "form:" + this.relBase;
    LDAPSecurityServiceConfig config;
    FeedbackPanel feedbackPanel = null;
    private static final String ldapServerUrl = "ldap://127.0.0.1";
    private static final String basePath = "dc=example,dc=com";
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();

    @After
    public void tearDown() throws Exception {
    }

    protected void setupPanel(String userDnPattern, String userFilter, String userFormat, String userGroupService) {
        this.config = new LDAPSecurityServiceConfig();
        this.config.setName("test");
        this.config.setServerURL(this.getServerURL());
        this.config.setUserDnPattern(userDnPattern);
        this.config.setUserFilter(userFilter);
        this.config.setUserFormat(userFormat);
        this.config.setUserGroupServiceName(userGroupService);
        this.setupPanel(this.config);
    }

    private String getServerURL() {
        return "ldap://127.0.0.1:" + serverRule.getLdapServer().getPort() + "/dc=example,dc=com";
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setEncryptingUrlParams(false);
        this.getSecurityManager().saveSecurityConfig(config);
    }

    protected void setupPanel(LDAPSecurityServiceConfig theConfig) {
        this.config = theConfig;
        tester.startPage((Page)new LDAPFormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 7319919840443122283L;

            public Component buildComponent(String id) {
                LDAPAuthProviderPanelTest.this.current = new LDAPAuthProviderPanel(id, (IModel)new Model((Serializable)LDAPAuthProviderPanelTest.this.config));
                return LDAPAuthProviderPanelTest.this.current;
            }
        }, (CompoundPropertyModel<Object>)new CompoundPropertyModel((Object)this.config)));
    }

    @Test
    public void testTestConnectionWithDnLookup() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(USER_DN_PATTERN, null, null, null);
        this.testSuccessfulConnection();
    }

    @Test
    public void testTestConnectionWitUserGroupService() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(USER_DN_PATTERN, null, null, "default");
        this.testSuccessfulConnection();
    }

    @Test
    public void testTestConnectionWithUserFilter() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(null, USER_FILTER, USER_FORMAT, null);
        this.testSuccessfulConnection();
    }

    @Test
    public void testTestConnectionFailedWithDnLookup() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(USER_DN_PATTERN, null, null, null);
        this.testFailedConnection();
    }

    @Test
    public void testTestConnectionFailedWithUserFilter() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(null, USER_FILTER, USER_FORMAT, null);
        this.testFailedConnection();
    }

    private void testSuccessfulConnection() throws Exception {
        this.authenticate("admin", "admin");
        tester.assertNoErrorMessage();
        String success = (String)new StringResourceModel(LDAPAuthProviderPanel.class.getSimpleName() + ".connectionSuccessful").getObject();
        tester.assertInfoMessages((Serializable[])new String[]{success});
    }

    private void testFailedConnection() throws Exception {
        this.authenticate("admin", "wrong");
        tester.assertNoInfoMessage();
        tester.assertContains("AuthenticationException");
    }

    private void authenticate(String username, String password) {
        TextField userField = (TextField)tester.getComponentFromLastRenderedPage(this.base + "testCx:username");
        userField.setDefaultModel((IModel)new Model((Serializable)((Object)username)));
        TextField passwordField = (TextField)tester.getComponentFromLastRenderedPage(this.base + "testCx:password");
        passwordField.setDefaultModel((IModel)new Model((Serializable)((Object)password)));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", username);
        map.put("password", password);
        tester.getComponentFromLastRenderedPage("form:panel:testCx").setDefaultModel((IModel)new MapModel(map));
        tester.clickLink(this.base + "testCx:test", true);
    }

    private class LDAPFormTestPage
    extends FormTestPage {
        private static final long serialVersionUID = 3150973967583096118L;

        public LDAPFormTestPage(ComponentBuilder builder, CompoundPropertyModel<Object> model) {
            super(builder, model);
        }

        protected void onBeforeRender() {
            LDAPAuthProviderPanelTest.this.feedbackPanel = new FeedbackPanel("topFeedback");
            LDAPAuthProviderPanelTest.this.feedbackPanel.setOutputMarkupId(true);
            this.addOrReplace(new Component[]{LDAPAuthProviderPanelTest.this.feedbackPanel});
            super.onBeforeRender();
        }
    }
}

