/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.io.Serializable;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.ldap.LDAPUserGroupServiceConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.security.ldap.LDAPUserGroupServicePanel;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
@ApplyLdifFiles(value={"data.ldif"})
public class LDAPUserGroupServicePanelTest
extends AbstractSecurityWicketTestSupport {
    private static final String GROUPS_BASE = "ou=Groups";
    private static final String USERS_BASE = "ou=People";
    private static final String GROUP_SEARCH_FILTER = "member=cn={0}";
    private static final String AUTH_USER = "admin";
    private static final String AUTH_PASSWORD = "secret";
    LDAPUserGroupServicePanel current;
    String relBase = "panel:";
    String base = "form:" + this.relBase;
    LDAPUserGroupServiceConfig config;
    FeedbackPanel feedbackPanel = null;
    private static final String ldapServerUrl = "ldap://127.0.0.1";
    private static final String basePath = "dc=example,dc=com";
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();

    @After
    public void tearDown() throws Exception {
    }

    protected void setupPanel(boolean needsAuthentication, boolean setRequiredFields) {
        this.config = new LDAPUserGroupServiceConfig();
        this.config.setName("test");
        if (setRequiredFields) {
            this.config.setServerURL(this.getServerURL());
            this.config.setGroupSearchBase(GROUPS_BASE);
            this.config.setUserSearchBase(USERS_BASE);
        }
        this.config.setBindBeforeGroupSearch(Boolean.valueOf(needsAuthentication));
        this.config.setGroupSearchFilter(GROUP_SEARCH_FILTER);
        this.config.setUser(AUTH_USER);
        this.config.setPassword(AUTH_PASSWORD);
        this.setupPanel();
    }

    private String getServerURL() {
        return "ldap://127.0.0.1:" + serverRule.getLdapServer().getPort() + "/dc=example,dc=com";
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setEncryptingUrlParams(false);
        this.getSecurityManager().saveSecurityConfig(config);
    }

    protected void setupPanel() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                LDAPUserGroupServicePanelTest.this.current = new LDAPUserGroupServicePanel(id, (IModel)new Model((Serializable)LDAPUserGroupServicePanelTest.this.config));
                return LDAPUserGroupServicePanelTest.this.current;
            }
        }, (IModel)new CompoundPropertyModel((Object)this.config)){
            private static final long serialVersionUID = -4090244876841730821L;

            protected void onInitialize() {
                LDAPUserGroupServicePanelTest.this.feedbackPanel = new FeedbackPanel("feedback");
                LDAPUserGroupServicePanelTest.this.feedbackPanel.setOutputMarkupId(true);
                this.add(new Component[]{LDAPUserGroupServicePanelTest.this.feedbackPanel});
                super.onInitialize();
            }
        });
    }

    @Test
    public void testDataLoadedFromConfigurationWithoutAuthentication() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(false, true);
        this.checkBaseConfig();
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("form:panel:authenticationPanel:user"));
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("form:panel:authenticationPanel:password"));
    }

    @Test
    public void testRequiredFields() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(false, false);
        tester.newFormTester("form").submit();
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Server URL' is required.", "Field 'Group search base' is required.", "Field 'User search base' is required."});
    }

    @Test
    public void testDataLoadedFromConfigurationWithAuthentication() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(true, true);
        this.checkBaseConfig();
        tester.assertModelValue("form:panel:authenticationPanel:user", (Object)AUTH_USER);
        tester.assertModelValue("form:panel:authenticationPanel:password", (Object)AUTH_PASSWORD);
    }

    @Test
    public void testAuthenticationDisabled() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(false, true);
        tester.assertInvisible("form:panel:authenticationPanel");
        tester.newFormTester("form").setValue("panel:bindBeforeGroupSearch", "on");
        tester.executeAjaxEvent("form:panel:bindBeforeGroupSearch", "click");
        tester.assertVisible("form:panel:authenticationPanel");
    }

    @Test
    public void testAuthenticationEnabled() throws Exception {
        serverRule.getDirectoryService().setAllowAnonymousAccess(true);
        this.setupPanel(true, true);
        tester.assertVisible("form:panel:authenticationPanel");
        tester.newFormTester("form").setValue("panel:bindBeforeGroupSearch", "");
        tester.executeAjaxEvent("form:panel:bindBeforeGroupSearch", "click");
        tester.assertInvisible("form:panel:authenticationPanel");
    }

    private void checkBaseConfig() {
        tester.assertModelValue("form:panel:serverURL", (Object)this.getServerURL());
        tester.assertModelValue("form:panel:groupSearchBase", (Object)GROUPS_BASE);
        tester.assertModelValue("form:panel:groupSearchFilter", (Object)GROUP_SEARCH_FILTER);
        tester.assertModelValue("form:panel:allGroupsSearchFilter", (Object)this.config.getAllGroupsSearchFilter());
    }
}

