/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.web.GeoServerWicketCoverageTestSupport;
import org.geoserver.wcs.web.WCSAdminPage;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geotools.api.util.InternationalString;
import org.junit.Assert;
import org.junit.Test;

public class WCSAdminPageTest
extends GeoServerWicketCoverageTestSupport {
    @Test
    public void test() throws Exception {
        this.login();
        WCSInfo wcs = (WCSInfo)this.getGeoServerApplication().getGeoServer().getService(WCSInfo.class);
        tester.startPage((Page)new WCSAdminPage());
        tester.assertRenderedPage(WCSAdminPage.class);
        tester.assertComponent("form:keywords", KeywordsEditor.class);
        tester.assertModelValue("form:keywords", (Object)wcs.getKeywords());
    }

    @Test
    public void testInternationalContent() {
        this.login();
        tester.startPage((Page)new WCSAdminPage());
        FormTester form = tester.newFormTester("form");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        DropDownChoice select = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select");
        Locale l10 = (Locale)select.getChoices().get(10);
        Locale l20 = (Locale)select.getChoices().get(20);
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international abstract");
        form.setValue("maxInputMemory", "1");
        form.setValue("maxOutputMemory", "1");
        form.setValue("maxRequestedDimensionValues", "1");
        form.setValue("defaultDeflateCompressionLevel", "5");
        form.submit("submit");
        tester.assertNoErrorMessage();
        WCSInfo wcs = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        InternationalString internationalTitle = wcs.getInternationalTitle();
        Assert.assertEquals((Object)"an international title", (Object)internationalTitle.toString(l10));
        Assert.assertEquals((Object)"another international title", (Object)internationalTitle.toString(l20));
        InternationalString internationalAbstract = wcs.getInternationalAbstract();
        Assert.assertEquals((Object)"an international abstract", (Object)internationalAbstract.toString(l10));
        Assert.assertEquals((Object)"another international abstract", (Object)internationalAbstract.toString(l20));
    }

    @Test
    public void testDefaultLocale() {
        this.login();
        tester.startPage(WCSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("maxInputMemory", "1");
        ft.setValue("maxOutputMemory", "1");
        ft.setValue("maxRequestedDimensionValues", "1");
        ft.select("defaultLocale", 11);
        ft.submit("submit");
        Assert.assertNotNull((Object)((WCSInfo)this.getGeoServer().getService(WCSInfo.class)).getDefaultLocale());
    }

    @Test
    public void testDefaultDeflate() {
        this.login();
        tester.startPage(WCSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("maxInputMemory", "1");
        ft.setValue("maxOutputMemory", "1");
        ft.setValue("maxRequestedDimensionValues", "1");
        ft.select("defaultLocale", 11);
        ft.setValue("defaultDeflateCompressionLevel", "20");
        ft.submit();
        tester.assertErrorMessages(new Serializable[]{"The value of 'Default Deflate Compression Level' must be between 1 and 9."});
    }
}

