/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

class WCS11GetCoverageTransformer
extends TransformerBase {
    static final Logger LOGGER = Logging.getLogger(WCS11GetCoverageTransformer.class);
    private Catalog catalog;
    private CoverageResponseDelegateFinder responseFactory;

    public WCS11GetCoverageTransformer(Catalog catalog, CoverageResponseDelegateFinder responseFactory) {
        this.catalog = catalog;
        this.responseFactory = responseFactory;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new ExecuteRequestTranslator(handler);
    }

    public class ExecuteRequestTranslator
    extends TransformerBase.TranslatorSupport {
        protected static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
        protected static final String XSI_PREFIX = "xsi";
        protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

        public ExecuteRequestTranslator(ContentHandler ch) {
            super(ch, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            GetCoverageRequest request = (GetCoverageRequest)o;
            this.encode(request);
        }

        private void encode(GetCoverageRequest request) {
            AttributesImpl attributes = this.attributes("version", "1.1.1", "service", "WCS", "xmlns:xsi", XSI_URI, "xmlns", WCS_URI, "xmlns:ows", "http://www.opengis.net/ows/1.1", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", "http://www.opengis.net/ogc", "xsi:schemaLocation", "http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd");
            this.start("GetCoverage", attributes);
            this.element("ows:Identifier", request.coverage);
            CoverageInfo coverage = WCS11GetCoverageTransformer.this.catalog.getCoverageByName(request.coverage);
            this.start("DomainSubset");
            this.handleSpatialSubset(request, coverage);
            this.end("DomainSubset");
            this.handleOutput(request);
            this.end("GetCoverage");
        }

        private void handleOutput(GetCoverageRequest request) {
            String format = request.outputFormat;
            CoverageResponseDelegate encoder = WCS11GetCoverageTransformer.this.responseFactory.encoderFor(format);
            String mime = encoder.getMimeType(request.outputFormat);
            this.start("Output", this.attributes("store", "true", "format", mime));
            if (request.targetCRS != null) {
                this.start("GridCRS");
                this.element("GridBaseCRS", this.epsgUrnCode(request.targetCRS));
                AffineTransform at = request.targetGridToWorld;
                if (at.getTranslateX() == 0.0 && at.getTranslateY() == 0.0 && at.getShearX() == 0.0 && at.getShearY() == 0.0) {
                    this.element("GridType", "urn:ogc:def:method:WCS:1.1:2dSimpleGrid");
                    this.element("GridOffsets", at.getScaleX() + " " + at.getScaleY());
                } else {
                    this.element("GridType", "urn:ogc:def:method:WCS:1.1:2dGridIn2dCrs");
                    this.element("GridOrigin", at.getTranslateX() + " " + at.getTranslateY());
                    this.element("GridOffsets", at.getScaleX() + " " + at.getShearX() + " " + at.getShearY() + " " + at.getScaleY());
                }
                this.element("GridCS", "urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS");
                this.end("GridCRS");
            }
            this.end("Output");
        }

        void handleSpatialSubset(GetCoverageRequest request, CoverageInfo coverage) {
            try {
                ReferencedEnvelope bounds = request.bounds;
                CoordinateReferenceSystem boundsCrs = bounds.getCoordinateReferenceSystem();
                String epsgCode = this.epsgUrnCode(boundsCrs);
                bounds = bounds.transform(CRS.decode((String)epsgCode), true);
                this.start("ows:BoundingBox", this.attributes("crs", epsgCode));
                this.element("ows:LowerCorner", bounds.getMinX() + " " + bounds.getMinY());
                this.element("ows:UpperCorner", bounds.getMaxX() + " " + bounds.getMaxY());
                this.end("ows:BoundingBox");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String epsgUrnCode(CoordinateReferenceSystem boundsCrs) {
            try {
                int epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)boundsCrs, (boolean)false);
                return "urn:ogc:def:crs:EPSG::" + epsg;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        AttributesImpl attributes(String ... nameValues) {
            AttributesImpl atts = new AttributesImpl();
            for (int i = 0; i < nameValues.length; i += 2) {
                String name = nameValues[i];
                String valu = nameValues[i + 1];
                atts.addAttribute(null, null, name, null, valu);
            }
            return atts;
        }
    }
}

