/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.web.GeoServerLoginPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.UnauthorizedPage;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.web.WFSAdminPage;
import org.geotools.api.util.InternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class WFSAdminPageTest
extends GeoServerWicketTestSupport {
    private static final String ROLE_CITE = "ROLE_CITE";
    public static final String CITE_WFS_TITLE = "This is the CITE WFS service";
    public static final String GLOBAL_WFS_TITLE = "This is the global WFS service";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void cleanupService() {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setTitle(null);
        gs.save((ServiceInfo)wfs);
        WorkspaceInfo citeWorkspace = this.getCatalog().getWorkspaceByName("cite");
        WFSInfo citeWFS = (WFSInfo)gs.getService(citeWorkspace, WFSInfo.class);
        if (citeWFS != null) {
            gs.remove((ServiceInfo)citeWFS);
        }
    }

    @Test
    public void testValues() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        this.login();
        tester.startPage(WFSAdminPage.class);
        tester.assertModelValue("form:maxFeatures", (Object)wfs.getMaxFeatures());
        tester.assertModelValue("form:csvDateFormat", (Object)wfs.getCsvDateFormat());
        tester.assertModelValue("form:maxNumberOfFeaturesForPreview", (Object)wfs.getMaxNumberOfFeaturesForPreview());
        tester.assertModelValue("form:keywords", (Object)wfs.getKeywords());
        tester.assertModelValue("form:getFeatureOutputTypes:outputTypeCheckingEnabled", (Object)wfs.isGetFeatureOutputTypeCheckingEnabled());
    }

    @Test
    public void testChangesToValues() throws Exception {
        String testValue1 = "100";
        String testValue2 = "0";
        WFSInfo wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        this.login();
        tester.startPage(WFSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("maxNumberOfFeaturesForPreview", testValue1);
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((String)"testValue1 = 100", (long)100L, (long)wfs.getMaxNumberOfFeaturesForPreview().intValue());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("maxNumberOfFeaturesForPreview", testValue2);
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((String)"testValue2 = 0", (long)0L, (long)wfs.getMaxNumberOfFeaturesForPreview().intValue());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("allowGlobalQueries", false);
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((String)"allowGlobalQueries = false", (Object)false, (Object)wfs.getAllowGlobalQueries());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("includeWFSRequestDumpFile", false);
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertFalse((String)"includeWFSRequestDumpFile= false", (boolean)wfs.getIncludeWFSRequestDumpFile());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("getFeatureOutputTypes:outputTypeCheckingEnabled", true);
        ft.getForm().get("getFeatureOutputTypes:palette").setDefaultModelObject(Collections.singleton("KML"));
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertTrue((String)"getFeatureOutputTypeCheckingEnabled= true", (boolean)wfs.isGetFeatureOutputTypeCheckingEnabled());
        Assert.assertEquals((String)"getFeatureOutputTypes= KML", Collections.singleton("KML"), (Object)wfs.getGetFeatureOutputTypes());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("disableStoredQueriesManagement", true);
        ft.submit("submit");
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertTrue((String)"disableStoredQueriesManagement = true", (boolean)wfs.isDisableStoredQueriesManagement());
    }

    @Test
    public void testApply() throws Exception {
        String testValue1 = "100";
        WFSInfo wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        this.login();
        tester.startPage(WFSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("maxNumberOfFeaturesForPreview", testValue1);
        ft.submit("apply");
        tester.assertRenderedPage(WFSAdminPage.class);
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((String)"testValue1 = 100", (long)100L, (long)wfs.getMaxNumberOfFeaturesForPreview().intValue());
        tester.startPage(WFSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("includeWFSRequestDumpFile", true);
        ft.submit("apply");
        tester.assertRenderedPage(WFSAdminPage.class);
        wfs = (WFSInfo)this.getGeoServerApplication().getGeoServer().getService(WFSInfo.class);
        Assert.assertTrue((String)"includeWFSRequestDumpFile = true", (boolean)wfs.getIncludeWFSRequestDumpFile());
    }

    @Test
    public void testGML32ForceMimeType() throws Exception {
        WFSInfo info = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        GMLInfo gmlInfo = (GMLInfo)info.getGML().get(WFSInfo.Version.V_20);
        gmlInfo.setMimeTypeToForce(null);
        this.getGeoServer().save((ServiceInfo)info);
        this.login();
        tester.startPage((Page)new WFSAdminPage());
        tester.assertComponent("form:gml32:forceGmlMimeType", CheckBox.class);
        CheckBox checkbox = (CheckBox)tester.getComponentFromLastRenderedPage("form:gml32:forceGmlMimeType");
        MatcherAssert.assertThat((Object)((Boolean)checkbox.getModelObject()), (Matcher)CoreMatchers.is((Object)false));
        tester.assertInvisible("form:gml32:mimeTypeToForce");
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("gml32:forceGmlMimeType", true);
        tester.executeAjaxEvent("form:gml32:forceGmlMimeType", "click");
        formTester = tester.newFormTester("form");
        formTester.submit("submit");
        tester.startPage((Page)new WFSAdminPage());
        MatcherAssert.assertThat((Object)((Boolean)checkbox.getModelObject()), (Matcher)CoreMatchers.is((Object)true));
        tester.assertVisible("form:gml32:mimeTypeToForce");
        info = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        gmlInfo = (GMLInfo)info.getGML().get(WFSInfo.Version.V_20);
        MatcherAssert.assertThat((Object)gmlInfo.getMimeTypeToForce().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        formTester = tester.newFormTester("form");
        formTester.select("gml32:mimeTypeToForce", 2);
        tester.executeAjaxEvent("form:gml32:mimeTypeToForce", "change");
        formTester = tester.newFormTester("form");
        formTester.submit("submit");
        info = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        gmlInfo = (GMLInfo)info.getGML().get(WFSInfo.Version.V_20);
        MatcherAssert.assertThat((Object)gmlInfo.getMimeTypeToForce().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)gmlInfo.getMimeTypeToForce().get()), (Matcher)CoreMatchers.is((Object)"text/xml"));
        tester.startPage((Page)new WFSAdminPage());
        formTester = tester.newFormTester("form");
        formTester.setValue("gml32:forceGmlMimeType", false);
        tester.executeAjaxEvent("form:gml32:forceGmlMimeType", "click");
        formTester = tester.newFormTester("form");
        formTester.submit("submit");
        tester.startPage((Page)new WFSAdminPage());
        MatcherAssert.assertThat((Object)((Boolean)checkbox.getModelObject()), (Matcher)CoreMatchers.is((Object)true));
        tester.assertInvisible("form:gml32:mimeTypeToForce");
        info = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        gmlInfo = (GMLInfo)info.getGML().get(WFSInfo.Version.V_20);
        MatcherAssert.assertThat((Object)gmlInfo.getMimeTypeToForce().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testInternationalContent() {
        this.login();
        tester.startPage((Page)new WFSAdminPage());
        FormTester form = tester.newFormTester("form");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        DropDownChoice select = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select");
        Locale l10 = (Locale)select.getChoices().get(10);
        Locale l20 = (Locale)select.getChoices().get(20);
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title for WFS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title for WFS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract for WFS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international abstract for WFS");
        form.setValue("maxFeatures", "999");
        form.select("encodeFeatureMember", 0);
        form.submit("submit");
        tester.assertNoErrorMessage();
        WFSInfo wfsInfo = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        InternationalString internationalTitle = wfsInfo.getInternationalTitle();
        Assert.assertEquals((Object)"an international title for WFS", (Object)internationalTitle.toString(l10));
        Assert.assertEquals((Object)"another international title for WFS", (Object)internationalTitle.toString(l20));
        InternationalString internationalAbstract = wfsInfo.getInternationalAbstract();
        Assert.assertEquals((Object)"an international abstract for WFS", (Object)internationalAbstract.toString(l10));
        Assert.assertEquals((Object)"another international abstract for WFS", (Object)internationalAbstract.toString(l20));
    }

    @Test
    public void testDefaultLocale() {
        this.login();
        tester.startPage(WFSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("defaultLocale", 11);
        ft.submit("submit");
        Assert.assertNotNull((Object)((WFSInfo)this.getGeoServer().getService(WFSInfo.class)).getDefaultLocale());
    }

    @Test
    public void testDateFormat() {
        this.login();
        tester.startPage(WFSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("csvDateFormat", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        ft.submit("submit");
        Assert.assertNotNull((Object)((WFSInfo)this.getGeoServer().getService(WFSInfo.class)).getCsvDateFormat());
        Assert.assertEquals((Object)((WFSInfo)this.getGeoServer().getService(WFSInfo.class)).getCsvDateFormat(), (Object)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    @Test
    public void testWorkspaceAdminFlagOn() throws IOException {
        System.setProperty("WORKSPACE_ADMIN_SERVICE_ACCESS", "true");
        WorkspaceInfo citeWorkspace = this.getCatalog().getWorkspaceByName("cite");
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setTitle(GLOBAL_WFS_TITLE);
        gs.save((ServiceInfo)wfs);
        WFSInfo citeWfs = (WFSInfo)gs.getFactory().create(WFSInfo.class);
        OwsUtils.copy((Object)wfs, (Object)citeWfs, WFSInfo.class);
        citeWfs.setWorkspace(citeWorkspace);
        citeWfs.setTitle(CITE_WFS_TITLE);
        gs.add((ServiceInfo)citeWfs);
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("cite.*.a", ROLE_CITE);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
        }
        DefaultFileAccessManager fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        fam.reload();
        this.logout();
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(GeoServerLoginPage.class);
        this.login("cite", "pwd", new String[]{ROLE_CITE});
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(UnauthorizedPage.class);
        tester.startPage(WFSAdminPage.class, new PageParameters().add("workspace", (Object)"cite"));
        tester.assertRenderedPage(WFSAdminPage.class);
        this.loginAsAdmin();
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(WFSAdminPage.class);
        System.clearProperty("WORKSPACE_ADMIN_SERVICE_ACCESS");
    }

    @Test
    public void testWorkspaceAdminFlagOff() throws IOException {
        System.clearProperty("WORKSPACE_ADMIN_SERVICE_ACCESS");
        WorkspaceInfo citeWorkspace = this.getCatalog().getWorkspaceByName("cite");
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setTitle(GLOBAL_WFS_TITLE);
        gs.save((ServiceInfo)wfs);
        WFSInfo citeWfs = (WFSInfo)gs.getFactory().create(WFSInfo.class);
        OwsUtils.copy((Object)wfs, (Object)citeWfs, WFSInfo.class);
        citeWfs.setWorkspace(citeWorkspace);
        citeWfs.setTitle(CITE_WFS_TITLE);
        gs.add((ServiceInfo)citeWfs);
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("cite.*.a", ROLE_CITE);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
        }
        DefaultFileAccessManager fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        fam.reload();
        this.logout();
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(GeoServerLoginPage.class);
        this.login("cite", "pwd", new String[]{ROLE_CITE});
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(UnauthorizedPage.class);
        tester.startPage(WFSAdminPage.class, new PageParameters().add("workspace", (Object)"cite"));
        tester.assertRenderedPage(UnauthorizedPage.class);
        this.loginAsAdmin();
        tester.startPage(WFSAdminPage.class);
        tester.assertRenderedPage(WFSAdminPage.class);
    }
}

