/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.wms.web.data.DataAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.util.Converters;

class DataAttributesProvider
extends GeoServerDataProvider<DataAttribute> {
    static final String COMPUTE_STATS = "computeStats";
    static final int MAX_SAMPLE_LENGTH = 200;
    private static final long serialVersionUID = 3228269047960562646L;
    private final List<DataAttribute> attributes = new ArrayList<DataAttribute>();

    public DataAttributesProvider(Feature sample) {
        for (PropertyDescriptor pd : sample.getType().getDescriptors()) {
            Name name = pd.getName();
            Object value = sample.getProperty(name).getValue();
            Object sampleValue = (String)Converters.convert((Object)value, String.class);
            if (sampleValue != null && ((String)sampleValue).length() > 200) {
                sampleValue = ((String)sampleValue).substring(0, 197) + "...";
            }
            String typeName = pd.getType().getBinding().getSimpleName();
            DataAttribute ad = new DataAttribute(name.getLocalPart(), typeName, (String)sampleValue);
            this.attributes.add(ad);
        }
    }

    public List<GeoServerDataProvider.Property<DataAttribute>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<DataAttribute>> props = new ArrayList<GeoServerDataProvider.Property<DataAttribute>>();
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.BeanProperty("name", "name"));
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.BeanProperty("type", "type"));
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.BeanProperty("sample", "sample"));
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.BeanProperty("min", "min"));
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.BeanProperty("max", "max"));
        props.add((GeoServerDataProvider.Property<DataAttribute>)new GeoServerDataProvider.PropertyPlaceholder(COMPUTE_STATS));
        return props;
    }

    public List<DataAttribute> getItems() {
        return Collections.unmodifiableList(this.attributes);
    }
}

