/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wms.web.data.DataAttribute;
import org.geoserver.wms.web.data.DataAttributesProvider;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class DataPanel
extends Panel {
    private static final long serialVersionUID = -2635691554700860434L;
    static final Logger LOGGER = Logging.getLogger(DataPanel.class);
    String featureTypeId;

    public DataPanel(String id, FeatureTypeInfo ft) {
        super(id, (IModel)new Model((Serializable)ft));
        Feature sample;
        this.featureTypeId = ft.getId();
        this.add(new Component[]{new Label("summary-message", (Serializable)((Object)"For reference, here is a listing of the attributes in this data set."))});
        final WebMarkupContainer attsContainer = new WebMarkupContainer("attributes-container");
        attsContainer.setOutputMarkupId(true);
        this.add(new Component[]{attsContainer});
        try {
            sample = this.getSampleFeature(ft);
        }
        catch (Exception e) {
            attsContainer.error((Serializable)((Object)("Failed to load attribute list, internal error is: " + e.getMessage())));
            attsContainer.add(new Component[]{new EmptyPanel("attributes")});
            return;
        }
        DataAttributesProvider summaries = new DataAttributesProvider(sample);
        GeoServerTablePanel<DataAttribute> attributes = new GeoServerTablePanel<DataAttribute>("attributes", (GeoServerDataProvider)summaries){
            private static final long serialVersionUID = 7753093373969576568L;

            protected Component getComponentForProperty(String id, final IModel<DataAttribute> itemModel, GeoServerDataProvider.Property<DataAttribute> property) {
                if ("computeStats".equals(property.getName())) {
                    Fragment f = new Fragment(id, "computeStatsFragment", (MarkupContainer)DataPanel.this);
                    f.add(new Component[]{new AjaxLink<Void>("computeStats"){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            DataAttribute attribute = (DataAttribute)itemModel.getObject();
                            try {
                                DataPanel.this.updateAttributeStats(attribute);
                            }
                            catch (IOException e) {
                                this.error((Serializable)((Object)("Failed to compute stats for the attribute: " + e.getMessage())));
                            }
                            target.add(new Component[]{attsContainer});
                        }
                    }});
                    return f;
                }
                return null;
            }
        };
        attributes.setPageable(false);
        attributes.setFilterable(false);
        attributes.setSortable(false);
        attsContainer.add(new Component[]{attributes});
    }

    protected void updateAttributeStats(DataAttribute attribute) throws IOException {
        FeatureTypeInfo featureType = GeoServerApplication.get().getCatalog().getFeatureType(this.featureTypeId);
        FeatureSource fs = featureType.getFeatureSource(null, null);
        PropertyDescriptor pd = fs.getSchema().getDescriptor(attribute.getName());
        Class binding = pd.getType().getBinding();
        if (pd == null || !Comparable.class.isAssignableFrom(binding) || Geometry.class.isAssignableFrom(binding)) {
            return;
        }
        Query q = new Query();
        q.setPropertyNames(new String[]{attribute.getName()});
        FeatureCollection fc = fs.getFeatures(q);
        MinVisitor minVisitor = new MinVisitor(attribute.getName());
        MaxVisitor maxVisitor = new MaxVisitor(attribute.getName());
        fc.accepts((FeatureVisitor)minVisitor, null);
        fc.accepts((FeatureVisitor)maxVisitor, null);
        Object min = minVisitor.getResult().getValue();
        attribute.setMin((String)Converters.convert((Object)min, String.class));
        Object max = maxVisitor.getResult().getValue();
        attribute.setMax((String)Converters.convert((Object)max, String.class));
    }

    private Feature getSampleFeature(FeatureTypeInfo layerInfo) throws IOException {
        FeatureSource fs = layerInfo.getFeatureSource(null, null);
        Query q = new Query();
        q.setMaxFeatures(1);
        FeatureCollection features = fs.getFeatures(q);
        try (FeatureIterator fi = features.features();){
            Feature feature = fi.next();
            return feature;
        }
    }
}

