/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.web.wicket.SimpleChoiceRenderer;
import org.geoserver.wms.web.publish.LegendGraphicAjaxUpdater;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleNameRenderer;
import org.geoserver.wms.web.publish.StylesModel;
import org.geotools.util.logging.Logging;

public class WMSLayerConfig
extends PublishedConfigurationPanel<LayerInfo> {
    static final Logger LOGGER = Logging.getLogger(WMSLayerConfig.class);
    private static final long serialVersionUID = -2895136226805357532L;

    public WMSLayerConfig(String id, IModel<LayerInfo> layerModel) {
        super(id, layerModel);
        this.add(new Component[]{new CheckBox("queryableEnabled", (IModel)new PropertyModel(layerModel, "queryable"))});
        this.add(new Component[]{new CheckBox("opaqueEnabled", (IModel)new PropertyModel(layerModel, "opaque"))});
        WebMarkupContainer styleContainer = new WebMarkupContainer("styles");
        this.add(new Component[]{styleContainer});
        ResourceInfo resource = ((LayerInfo)layerModel.getObject()).getResource();
        styleContainer.setVisible(resource instanceof CoverageInfo || resource instanceof FeatureTypeInfo);
        StylesModel styles = new StylesModel();
        PropertyModel defaultStyleModel = new PropertyModel(layerModel, "defaultStyle");
        Select2DropDownChoice defaultStyle = new Select2DropDownChoice("defaultStyle", (IModel)defaultStyleModel, (IModel)styles, (IChoiceRenderer)new StyleChoiceRenderer());
        defaultStyle.setRequired(true);
        styleContainer.add(new Component[]{defaultStyle});
        NonCachingImage defStyleImg = new NonCachingImage("defaultStyleLegendGraphic");
        defStyleImg.setOutputMarkupId(true);
        styleContainer.add(new Component[]{defStyleImg});
        final LegendGraphicAjaxUpdater defaultStyleUpdater = new LegendGraphicAjaxUpdater((Image)defStyleImg, (IModel<StyleInfo>)defaultStyleModel);
        defaultStyle.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = -4098934889965471248L;

            protected void onUpdate(AjaxRequestTarget target) {
                defaultStyleUpdater.updateStyleImage(target);
            }
        }});
        LiveCollectionModel stylesModel = LiveCollectionModel.set((IModel)new PropertyModel(layerModel, "styles"));
        Palette<StyleInfo> extraStyles = new Palette<StyleInfo>("extraStyles", (IModel)stylesModel, (IModel)styles, (IChoiceRenderer)new StyleNameRenderer(), 10, false){
            private static final long serialVersionUID = -3494299396410932090L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.availableHeader"));
            }
        };
        extraStyles.add(new Behavior[]{new DefaultTheme()});
        styleContainer.add(new Component[]{extraStyles});
        TextField renderingBuffer = new TextField("renderingBuffer", (IModel)new MapModel((IModel)new PropertyModel(layerModel, "metadata"), "buffer"), Integer.class);
        renderingBuffer.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        styleContainer.add(new Component[]{renderingBuffer});
        this.add(new Component[]{new TextField("wmsPath", (IModel)new PropertyModel(layerModel, "path"))});
        List<LayerInfo.WMSInterpolation> interpolChoices = Arrays.asList(LayerInfo.WMSInterpolation.values());
        PropertyModel defaultInterpolModel = new PropertyModel(layerModel, "defaultWMSInterpolationMethod");
        DropDownChoice interpolDropDown = new DropDownChoice("defaultInterpolationMethod", (IModel)defaultInterpolModel, interpolChoices, (IChoiceRenderer)new InterpolationRenderer((Component)this));
        interpolDropDown.setNullValid(true);
        this.add(new Component[]{interpolDropDown});
        this.initWMSCascadedUI(layerModel);
    }

    private void initWMSCascadedUI(IModel<LayerInfo> layerModel) {
        WebMarkupContainer styleContainer = new WebMarkupContainer("remotestyles");
        WebMarkupContainer remoteForamtsContainer = new WebMarkupContainer("remoteformats");
        WebMarkupContainer metaDataCheckBoxContainer = new WebMarkupContainer("metaDataCheckBoxContainer");
        WebMarkupContainer scaleDenominatorContainer = new WebMarkupContainer("scaleDenominatorContainer");
        this.add(new Component[]{styleContainer});
        this.add(new Component[]{remoteForamtsContainer});
        this.add(new Component[]{metaDataCheckBoxContainer});
        this.add(new Component[]{scaleDenominatorContainer});
        if (!(((LayerInfo)layerModel.getObject()).getResource() instanceof WMSLayerInfo)) {
            styleContainer.setVisible(false);
            remoteForamtsContainer.setVisible(false);
            metaDataCheckBoxContainer.setVisible(false);
            scaleDenominatorContainer.setVisible(false);
            return;
        }
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)((LayerInfo)layerModel.getObject()).getResource();
        try {
            if (((LayerInfo)layerModel.getObject()).getId() == null) {
                wmsLayerInfo.reset();
            } else {
                wmsLayerInfo.getAllAvailableRemoteStyles().clear();
                wmsLayerInfo.getAllAvailableRemoteStyles().addAll(wmsLayerInfo.getRemoteStyleInfos());
            }
        }
        catch (Exception e) {
            this.error((Serializable)((Object)("unable to fetch remote styles for " + wmsLayerInfo.getNativeName())));
            LOGGER.log(Level.SEVERE, e.getMessage() + ":unable to fetch remote styles for " + wmsLayerInfo.getNativeName(), e);
        }
        ArrayList<String> remoteSyles = new ArrayList<String>();
        remoteSyles.add("");
        remoteSyles.addAll(this.getRemoteStyleNames(wmsLayerInfo.getAllAvailableRemoteStyles()));
        DropDownChoice remotStyles = new DropDownChoice("remoteStylesDropDown", (IModel)new PropertyModel((Object)wmsLayerInfo, "forcedRemoteStyle"), remoteSyles);
        styleContainer.add(new Component[]{remotStyles});
        LiveCollectionModel stylesModel = LiveCollectionModel.set((IModel)new PropertyModel((Object)wmsLayerInfo, "selectedRemoteStyles"));
        Palette extraRemoteStyles = new Palette("extraRemoteStyles", (IModel)stylesModel, (IModel)new CollectionModel(this.getRemoteStyleNames(wmsLayerInfo.getAllAvailableRemoteStyles())), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, true);
        extraRemoteStyles.add(new Behavior[]{new DefaultTheme()});
        styleContainer.add(new Component[]{extraRemoteStyles});
        DropDownChoice remoteForamts = new DropDownChoice("remoteFormatsDropDown", (IModel)new PropertyModel((Object)wmsLayerInfo, "preferredFormat"), wmsLayerInfo.availableFormats());
        remoteForamtsContainer.add(new Component[]{remoteForamts});
        LiveCollectionModel remoteFormatsModel = LiveCollectionModel.set((IModel)new PropertyModel((Object)wmsLayerInfo, "selectedRemoteFormats"));
        Palette remoteFormatsPalette = new Palette("remoteFormatsPalette", (IModel)remoteFormatsModel, (IModel)new CollectionModel((Collection)wmsLayerInfo.availableFormats()), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, true);
        remoteFormatsPalette.add(new Behavior[]{new DefaultTheme()});
        remoteForamtsContainer.add(new Component[]{remoteFormatsPalette});
        metaDataCheckBoxContainer.add(new Component[]{new CheckBox("respectMetadataBBoxChkBox", (IModel)new PropertyModel((Object)wmsLayerInfo, "metadataBBoxRespected"))});
        TextField minScale = new TextField("minScale", (IModel)new PropertyModel((Object)wmsLayerInfo, "minScale"), Double.class);
        scaleDenominatorContainer.add(new Component[]{minScale});
        TextField maxScale = new TextField("maxScale", (IModel)new PropertyModel((Object)wmsLayerInfo, "maxScale"), Double.class);
        scaleDenominatorContainer.add(new Component[]{maxScale});
        minScale.add((IValidator)new ScalesValidator((TextField<Double>)minScale, (TextField<Double>)maxScale));
    }

    private Set<String> getRemoteStyleNames(List<StyleInfo> styleInfoList) {
        return styleInfoList.stream().map(s -> s.getName()).collect(Collectors.toSet());
    }

    private class ScalesValidator
    implements IValidator<Double> {
        private static final long serialVersionUID = 1349568700386246273L;
        TextField<Double> minScale;
        TextField<Double> maxScale;

        public ScalesValidator(TextField<Double> minScale, TextField<Double> maxScale) {
            this.minScale = minScale;
            this.maxScale = maxScale;
        }

        private Double safeGet(String input, Double defaultValue) {
            if (input == null || input.isEmpty()) {
                return defaultValue;
            }
            return Double.valueOf(input);
        }

        public void validate(IValidatable validatable) {
            if (this.minScale.getInput() != null && this.maxScale.getInput() != null) {
                if (Double.valueOf(this.minScale.getInput()) < 0.0 || Double.valueOf(this.maxScale.getInput()) < 0.0) {
                    validatable.error((IValidationError)new ValidationError("Scale denominator cannot be Negative"));
                }
                if (this.safeGet(this.minScale.getInput(), 0.0) >= this.safeGet(this.maxScale.getInput(), (Double)Double.MAX_VALUE)) {
                    validatable.error((IValidationError)new ValidationError("Minimum Scale cannot be greater than Maximum Scale"));
                }
            }
        }
    }

    private class InterpolationRenderer
    extends ChoiceRenderer<LayerInfo.WMSInterpolation> {
        private static final long serialVersionUID = 4230274692882585457L;
        private Component parent;

        public InterpolationRenderer(Component parent) {
            this.parent = parent;
        }

        public Object getDisplayValue(LayerInfo.WMSInterpolation interpolationMethod) {
            return new StringResourceModel(interpolationMethod.name(), this.parent).getString();
        }

        public String getIdValue(LayerInfo.WMSInterpolation object, int index) {
            return object.name();
        }
    }
}

