/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api;

import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class APIExamples {
    private void exampleISOEnvelope() throws Exception {
        CoordinateReferenceSystem wsg84 = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 10.0, 0.0, 20.0, wsg84);
        double xMin = envelope.getMinimum(0);
        double yMin = envelope.getMinimum(1);
        double xMax = envelope.getMaximum(0);
        double yMax = envelope.getMaximum(1);
        double width = envelope.getSpan(0);
        double height = envelope.getSpan(1);
        double xCenter = envelope.getMedian(0);
        double yCenter = envelope.getMedian(1);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        upper.setOrdinate(0, Math.max(upper.getOrdinate(0), 15.0));
        upper.setOrdinate(1, Math.max(upper.getOrdinate(1), 30.0));
        lower.setOrdinate(0, Math.min(lower.getOrdinate(0), 15.0));
        lower.setOrdinate(1, Math.min(lower.getOrdinate(1), 30.0));
    }

    private void exampleBoundingBox() throws Exception {
        CoordinateReferenceSystem wsg84 = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope bbox = new ReferencedEnvelope(0.0, 10.0, 0.0, 20.0, wsg84);
        double xMin = bbox.getMinX();
        double yMin = bbox.getMinY();
        double xMax = bbox.getMaxX();
        double yMax = bbox.getMaxY();
        double width = bbox.getWidth();
        double height = bbox.getHeight();
        double xCenter = bbox.getMedian(0);
        double yCenter = bbox.getMedian(1);
        CoordinateReferenceSystem crs = bbox.getCoordinateReferenceSystem();
        DirectPosition lower = bbox.getLowerCorner();
        DirectPosition upper = bbox.getUpperCorner();
        bbox.include(15.0, 30.0);
    }

    private void exampleEnvelope() throws Exception {
        org.locationtech.jts.geom.Envelope envelope = new org.locationtech.jts.geom.Envelope(0.0, 10.0, 0.0, 20.0);
        double xMin = envelope.getMinX();
        double yMin = envelope.getMinY();
        double xMax = envelope.getMaxX();
        double yMax = envelope.getMaxY();
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        org.locationtech.jts.geom.Envelope bbox = new org.locationtech.jts.geom.Envelope();
        envelope.expandToInclude(bbox);
        envelope.covers(5.0, 10.0);
        envelope.contains(5.0, 10.0);
        envelope.isNull();
        envelope.setToNull();
    }

    private void transformEnvelope() throws Exception {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:23032");
        org.locationtech.jts.geom.Envelope envelope = new org.locationtech.jts.geom.Envelope(0.0, 10.0, 0.0, 20.0);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        org.locationtech.jts.geom.Envelope quick = JTS.transform((org.locationtech.jts.geom.Envelope)envelope, (MathTransform)transform);
        org.locationtech.jts.geom.Envelope better = JTS.transform((org.locationtech.jts.geom.Envelope)envelope, null, (MathTransform)transform, (int)10);
    }

    private void exampleReferencedEnvelope() throws Exception {
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 10.0, 0.0, 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double xMin = envelope.getMinX();
        double yMin = envelope.getMinY();
        double xMax = envelope.getMaxX();
        double yMax = envelope.getMaxY();
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        double xCenter = envelope.getMedian(0);
        double yCenter = envelope.getMedian(1);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        int dimension = envelope.getDimension();
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        envelope.include(15.0, 30.0);
        envelope.isEmpty();
        envelope.isNull();
        envelope.setToNull();
    }

    private void exampleReferencedEnvelope3D() throws Exception {
        ReferencedEnvelope3D envelope = new ReferencedEnvelope3D(0.0, 10.0, 0.0, 20.0, 0.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        double xMin = envelope.getMinX();
        double yMin = envelope.getMinY();
        double zMin = envelope.getMinZ();
        double xMax = envelope.getMaxX();
        double yMax = envelope.getMaxY();
        double zMax = envelope.getMaxZ();
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        double depth = envelope.getDepth();
        double xCenter = envelope.getMedian(0);
        double yCenter = envelope.getMedian(1);
        double zCenter = envelope.getMedian(2);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        int dimension = envelope.getDimension();
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        envelope.include(15.0, 30.0, 40.0);
        envelope.isEmpty();
        envelope.isNull();
        envelope.setToNull();
    }

    private void exampleReferencedEnvelopeStaticMethods() throws Exception {
        ReferencedEnvelope original = null;
        CoordinateReferenceSystem crs = null;
        Envelope opengis_env = null;
        org.locationtech.jts.geom.Envelope jts_env = null;
        Envelope bbox = null;
        ReferencedEnvelope env = ReferencedEnvelope.create(original);
        env = ReferencedEnvelope.create(crs);
        env = ReferencedEnvelope.create(opengis_env, crs);
        env = ReferencedEnvelope.create(jts_env, crs);
        env = ReferencedEnvelope.reference(opengis_env);
        env = ReferencedEnvelope.reference(jts_env);
        env = ReferencedEnvelope.reference(bbox);
    }

    private void transformReferencedEnvelope() throws Exception {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 10.0, 0.0, 20.0, sourceCRS);
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:23032");
        ReferencedEnvelope result = envelope.transform(targetCRS, true, 10);
    }

    private void transformGeometry() throws Exception {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:23032");
        org.locationtech.jts.geom.Envelope envelope = new org.locationtech.jts.geom.Envelope(0.0, 10.0, 0.0, 20.0);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        org.locationtech.jts.geom.Envelope quick = JTS.transform((org.locationtech.jts.geom.Envelope)envelope, (MathTransform)transform);
        org.locationtech.jts.geom.Envelope better = JTS.transform((org.locationtech.jts.geom.Envelope)envelope, null, (MathTransform)transform, (int)10);
    }
}

