/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cql;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.geotools.cql.DataExamples;
import org.geotools.cql.Utility;
import org.geotools.filter.text.cql2.CQL;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;

public class CQLExamples {
    private static final Logger LOGGER = Logger.getLogger(CQLExamples.class.getName());

    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.println("Select the CQL Example:");
                System.out.println(" 1 - Comparison: population >= 10000000");
                System.out.println(" 2 - Using functions in comparison predicate: ");
                System.out.println(" 3 - like using property name: cityName LIKE 'New%");
                System.out.println(" 4 - Between: population Between 10000 and 20000");
                System.out.println(" 5 - Spatial Operation using the contains DE-9IM: RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
                System.out.println(" 6 - Temporal After: lastEarthQuake AFTER 2006-11-30T01:30:00Z");
                System.out.println(" 7 - Temporal After: lastEarthQuake AFTER 2006-11-30T01:30:00+03:00");
                System.out.println(" 8 - Temporal Before: lastEarthQuake BEFORE 2006-11-30T01:30:00Z");
                System.out.println(" 9 - Temporal During: lastEarthQuake DURING 2006-11-30T00:30:00Z/2006-11-30T01:30:00Z ");
                System.out.println(" 0 - quite");
                System.out.print(">");
                String line = reader.readLine();
                if (line == null) {
                    return;
                }
                int option = Integer.parseInt(line);
                switch (option) {
                    case 0: {
                        System.out.println("bye!");
                        return;
                    }
                    case 1: {
                        CQLExamples.comparisonPredicate();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        CQLExamples.likePredicate();
                        break;
                    }
                    case 4: {
                        CQLExamples.betweenPredicate();
                        break;
                    }
                    case 5: {
                        CQLExamples.relatePattern();
                        break;
                    }
                    case 6: {
                        CQLExamples.afterPredicate();
                        break;
                    }
                    case 7: {
                        CQLExamples.afterPredicateGMT3();
                        break;
                    }
                    case 8: {
                        CQLExamples.beforePredicate();
                        break;
                    }
                    case 9: {
                        CQLExamples.duringPredicate();
                        break;
                    }
                    default: {
                        System.out.println("invalid option");
                    }
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return;
        }
    }

    private static void beforePredicate() throws Exception {
        Before filter = (Before)CQL.toFilter((String)"lastEarthQuake BEFORE 2006-11-30T01:30:00Z");
        Utility.prittyPrintFilter((Filter)filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Expression leftExpr = filter.getExpression1();
        Expression rightExpr = filter.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void afterPredicate() throws Exception {
        After filter = (After)CQL.toFilter((String)"lastEarthQuake AFTER 2006-11-30T01:30:00Z");
        Utility.prittyPrintFilter((Filter)filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Expression leftExpr = filter.getExpression1();
        Expression rightExpr = filter.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void afterPredicateGMT3() throws Exception {
        After filter = (After)CQL.toFilter((String)"lastEarthQuake AFTER 2006-11-30T01:30:00+03:00");
        Utility.prittyPrintFilter((Filter)filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Expression leftExpr = filter.getExpression1();
        Expression rightExpr = filter.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void duringPredicate() throws Exception {
        During filter = (During)CQL.toFilter((String)"lastEarthQuake DURING 1700-01-01T00:00:00/2011-01-01T00:00:00");
        Utility.prittyPrintFilter((Filter)filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Expression leftExpr = filter.getExpression1();
        Expression rightExpr = filter.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void relatePattern() throws Exception {
        Filter filter = CQL.toFilter((String)"RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
        Utility.prittyPrintFilter(filter);
        SimpleFeature usa = DataExamples.getInstanceOfCountry();
        Boolean result = filter.evaluate((Object)usa);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void comparisonPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"population >= 10000000");
        SimpleFeature city = DataExamples.getInstanceOfCity();
        System.out.println("City population: " + city.getProperty("population").getValue());
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void betweenPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"population BETWEEN 10000000 and 20000000");
        Utility.prittyPrintFilter(filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        System.out.println("City population: " + city.getProperty("population").getValue());
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void likePredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"cityName LIKE 'New%'");
        Utility.prittyPrintFilter(filter);
        SimpleFeature newYork = DataExamples.getInstanceOfCity();
        System.out.println("City Name: " + newYork.getProperty("cityName").getValue());
        Boolean result = filter.evaluate((Object)newYork);
        System.out.println("Result of filter evaluation: " + result);
    }
}

