/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cql;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.geotools.cql.DataExamples;
import org.geotools.cql.Utility;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.temporal.During;

public class ECQLExamples {
    private static final Logger LOGGER = Logger.getLogger(ECQLExamples.class.getName());

    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.println("Select the ECQL Example:");
                System.out.println(" 1 - CQL Compatibility");
                System.out.println(" 2 - Comparison with property in the right hand: 1000 <= POPULTATION");
                System.out.println(" 3 - Using functions in comparison predicate: ...");
                System.out.println(" 4 - like pattern using String: 'aabbcc' LIKE '%bb%'");
                System.out.println(" 5 - like using property name: cityName LIKE 'New%");
                System.out.println(" 6 - Insensitive like: cityName ILIKE 'new%'");
                System.out.println(" 7 - Comparison: (under18YearsOld * 19541453 / 100 ) < (over65YearsOld * 19541453 / 100 )");
                System.out.println(" 8 - Between: population Between 10000 and 20000");
                System.out.println(" 9 - area( shape ) BETWEEN 10000 AND 30000");
                System.out.println("10 - Spatial Operation using the contains DE-9IM: RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
                System.out.println("11 - Spatial Operation using geometry expressions: INTERSECTS(POLYGON((1 2, 2 2, 2 3, 1 2)), POINT(1 2))");
                System.out.println("12 - Temporal After: 2006-11-30T01:00:00Z AFTER 2006-11-30T01:30:00Z");
                System.out.println("13 - Temporal Before: 2006-11-30T01:00:00Z BEFORE 2006-11-30T01:30:00Z");
                System.out.println("14 - Temporal During: 2006-11-30T01:00:00Z DURING 2006-11-30T00:30:00Z/2006-11-30T01:30:00Z ");
                System.out.println("15 - Temporal During: lastEarthQuake DURING 1700-01-01T00:00:00Z/2011-01-01T00:00:00Z");
                System.out.println("16 - In predicate: principalMineralResource IN ('silver','oil', 'gold' )");
                System.out.println("17 - Temporal During using UTC Zone +3: 2006-11-30T01:00:00+03:00 DURING 2006-11-30T00:30:00+03:00/2006-11-30T01:30:00+03:00");
                System.out.println("18 - Spatial Operation using the contains DE-9IM: RELATE(geometry, SRID=4326;LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
                System.out.println("0 - Quit");
                System.out.print(">");
                String line = reader.readLine();
                if (line == null) {
                    return;
                }
                int option = Integer.parseInt(line);
                switch (option) {
                    case 0: {
                        System.out.println("bye!");
                        return;
                    }
                    case 1: {
                        ECQLExamples.comparisonPredicateCQLCompatibility();
                        break;
                    }
                    case 2: {
                        ECQLExamples.expressionLessThanOrEqualToProperty();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        ECQLExamples.likePredicateInString();
                        break;
                    }
                    case 5: {
                        ECQLExamples.likePredicate();
                        break;
                    }
                    case 6: {
                        ECQLExamples.ilikePredicate();
                        break;
                    }
                    case 7: {
                        ECQLExamples.comparisonUsingExpressions();
                        break;
                    }
                    case 8: {
                        ECQLExamples.betweenPredicate();
                        break;
                    }
                    case 9: {
                        ECQLExamples.betweenUsingExpression();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        ECQLExamples.relatePattern();
                        break;
                    }
                    case 12: {
                        ECQLExamples.afterPredicateWithLefHandtExpression();
                        break;
                    }
                    case 13: {
                        ECQLExamples.beforePredicateWithLefHandtExpression();
                        break;
                    }
                    case 14: {
                        ECQLExamples.duringPredicateWithLefHandtExpression();
                        break;
                    }
                    case 15: {
                        ECQLExamples.duringPredicateWithLefHandtAttribute();
                        break;
                    }
                    case 16: {
                        ECQLExamples.inPredicate();
                        break;
                    }
                    case 17: {
                        ECQLExamples.utcTimeZone();
                        break;
                    }
                    case 18: {
                        ECQLExamples.referencedRelatePattern();
                        break;
                    }
                    default: {
                        System.out.println("invalid option");
                    }
                }
                System.out.println("Press a key to continue.");
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return;
        }
    }

    private static void relatePattern() throws Exception {
        Filter filter = ECQL.toFilter((String)"RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
        Utility.prittyPrintFilter(filter);
        SimpleFeature usa = DataExamples.getInstanceOfCountry();
        Boolean result = filter.evaluate((Object)usa);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void referencedRelatePattern() throws Exception {
        Filter filter = ECQL.toFilter((String)"RELATE(geometry, SRID=4326;LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
        Utility.prittyPrintFilter(filter);
        SimpleFeature usa = DataExamples.getInstanceOfCountry();
        Boolean result = filter.evaluate((Object)usa);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void afterPredicateWithLefHandtExpression() throws Exception {
        Filter filter = ECQL.toFilter((String)"2006-11-30T01:00:00Z AFTER 2006-11-30T01:30:00Z");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void beforePredicateWithLefHandtExpression() throws Exception {
        Filter filter = ECQL.toFilter((String)"2006-11-30T01:00:00Z BEFORE 2006-11-30T01:30:00Z");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void duringPredicateWithLefHandtExpression() throws Exception {
        Filter filter = ECQL.toFilter((String)"2006-11-30T01:00:00Z DURING 2006-11-30T00:30:00Z/2006-11-30T01:30:00Z ");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void utcTimeZone() throws Exception {
        Filter filter = ECQL.toFilter((String)"2006-11-30T01:00:00+03:00 DURING 2006-11-30T00:30:00+03:00/2006-11-30T01:30:00+03:00 ");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
        During during = (During)filter;
        Literal literal = (Literal)during.getExpression1();
        Date date = (Date)literal.getValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        TimeZone tz = TimeZone.getTimeZone("GMT+0300");
        sdf.setTimeZone(tz);
        System.out.println("Expression 1 as Date: " + sdf.format(date));
    }

    private static void duringPredicateWithLefHandtAttribute() throws Exception {
        During filter = (During)ECQL.toFilter((String)"lastEarthQuake DURING 1700-01-01T00:00:00Z/2011-01-01T00:00:00Z");
        Utility.prittyPrintFilter((Filter)filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Expression leftExpr = filter.getExpression1();
        Expression rightExpr = filter.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void comparisonPredicateCQLCompatibility() throws Exception {
        Filter filterFromCQL;
        Filter filter = ECQL.toFilter((String)"POPULTATION >= 1000");
        if (!filter.equals(filterFromCQL = CQL.toFilter((String)"POPULTATION >= 1000"))) {
            throw new Exception("uncompatible ECQL Syntax");
        }
        System.out.println("CQL and ECQL have produced the same filter for the predicate \"POPULTATION >= 1000\"");
        Utility.prittyPrintFilter(filter);
    }

    private static void expressionLessThanOrEqualToProperty() throws Exception {
        Filter filter = ECQL.toFilter((String)"1000 <= population");
        Utility.prittyPrintFilter(filter);
        SimpleFeature usa = DataExamples.getInstanceOfCountry();
        System.out.println("Country: " + usa.getProperty("countryName").getValue());
        System.out.println("Population: " + usa.getProperty("population").getValue());
        Boolean result = filter.evaluate((Object)usa);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void comparisonUsingExpressions() throws Exception {
        Filter filter = ECQL.toFilter((String)"(under18YearsOld * 19541453 / 100 ) < (over65YearsOld * 19541453 / 100 )");
        SimpleFeature city = DataExamples.getInstanceOfCity();
        Utility.prittyPrintFilter(filter);
        PropertyIsLessThan lessThan = (PropertyIsLessThan)filter;
        Expression leftExpr = lessThan.getExpression1();
        Expression rightExpr = lessThan.getExpression2();
        System.out.println("left expression value: " + leftExpr.evaluate((Object)city));
        System.out.println("right expression value: " + rightExpr.evaluate((Object)city));
        Boolean result = lessThan.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void betweenPredicate() throws Exception {
        Filter filter = ECQL.toFilter((String)"population BETWEEN 10000000 and 20000000");
        Utility.prittyPrintFilter(filter);
        SimpleFeature city = DataExamples.getInstanceOfCity();
        System.out.println("City population: " + city.getProperty("population").getValue());
        Boolean result = filter.evaluate((Object)city);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void betweenUsingExpression() throws Exception {
        Filter filter = ECQL.toFilter((String)"area( Polygon((10 10, 20 10, 20 20, 10 10)) ) BETWEEN 10000 AND 30000");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void likePredicate() throws Exception {
        Filter filter = ECQL.toFilter((String)"cityName LIKE 'New%'");
        Utility.prittyPrintFilter(filter);
        SimpleFeature newYork = DataExamples.getInstanceOfCity();
        System.out.println("City Name: " + newYork.getProperty("cityName").getValue());
        Boolean result = filter.evaluate((Object)newYork);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void ilikePredicate() throws Exception {
        Filter filter = ECQL.toFilter((String)"cityName ILIKE 'new%'");
        Utility.prittyPrintFilter(filter);
        SimpleFeature newYork = DataExamples.getInstanceOfCity();
        System.out.println("City Name: " + newYork.getProperty("cityName").getValue());
        Boolean result = filter.evaluate((Object)newYork);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void likePredicateInString() throws Exception {
        Filter filter = ECQL.toFilter((String)"'aabbcc' LIKE '%bb%'");
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate(null);
        System.out.println("Result of filter evaluation: " + result);
    }

    private static void inPredicate() throws Exception {
        Filter filter = ECQL.toFilter((String)"principalMineralResource IN ('silver','oil', 'gold' )");
        SimpleFeature country = DataExamples.getInstanceOfCountry();
        System.out.println("coutry: " + country.getAttribute("countryName"));
        System.out.println("population: " + country.getAttribute("principalMineralResource"));
        Utility.prittyPrintFilter(filter);
        Boolean result = filter.evaluate((Object)country);
        System.out.println("Result of filter evaluation: " + result);
    }
}

