/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.WKTReader2;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryExamples {
    public void createCurve() {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        CurvedGeometryFactory curvedFactory = new CurvedGeometryFactory(geometryFactory, Double.MAX_VALUE);
        CoordinateSequence coords = PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(new double[]{10.0, 14.0, 6.0, 10.0, 14.0, 10.0}, 2);
        CircularString arc = (CircularString)curvedFactory.createCurvedGeometry(coords);
    }

    public void wktCurve() throws Exception {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        CurvedGeometryFactory curvedfactory = new CurvedGeometryFactory(Double.MAX_VALUE);
        WKTReader2 reader = new WKTReader2((GeometryFactory)curvedfactory);
        CircularString arc = (CircularString)reader.read("CIRCULARSTRING(10 14,6 10,14 10)");
    }

    public void createPoint() {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Coordinate coord = new Coordinate(1.0, 1.0);
        Point point = geometryFactory.createPoint(coord);
    }

    public void createPointWKT() throws ParseException {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        WKTReader reader = new WKTReader(geometryFactory);
        Point point = (Point)reader.read("POINT (1 1)");
    }

    public boolean hit(Point point, Geometry geometry) {
        double MAX_DISTANCE = 0.001;
        switch (Geometries.get((Geometry)geometry)) {
            case POINT: 
            case MULTIPOINT: 
            case LINESTRING: 
            case MULTILINESTRING: {
                return geometry.isWithinDistance((Geometry)point, 0.001);
            }
            case POLYGON: 
            case MULTIPOLYGON: {
                return geometry.contains((Geometry)point);
            }
        }
        return geometry.isWithinDistance((Geometry)point, 0.001);
    }
}

