/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.PolygonElement;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

public class IntersectionBuilder
extends GridFeatureBuilder {
    final FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2();
    final GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
    final SimpleFeatureSource source;
    int id = 0;

    public IntersectionBuilder(SimpleFeatureType type, SimpleFeatureSource source) {
        super(type);
        this.source = source;
    }

    public void setAttributes(GridElement el, Map<String, Object> attributes) {
        attributes.put("id", ++this.id);
    }

    public boolean getCreateFeature(GridElement el) {
        Coordinate c = ((PolygonElement)el).getCenter();
        Point p = this.gf.createPoint(c);
        Intersects filter = this.ff2.intersects((Expression)this.ff2.property("the_geom"), (Expression)this.ff2.literal((Object)p));
        boolean result = false;
        try {
            result = !this.source.getFeatures((Filter)filter).isEmpty();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }
}

