/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jts;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.util.ProgressListener;

public class SnapToLine {
    public static void main(String[] args) throws Exception {
        boolean isLine;
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource source = store.getFeatureSource();
        Class geomBinding = source.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean bl = isLine = geomBinding != null && (LineString.class.isAssignableFrom(geomBinding) || MultiLineString.class.isAssignableFrom(geomBinding));
        if (!isLine) {
            System.out.println("This example needs a shapefile with line features");
            return;
        }
        STRtree index = new STRtree();
        FeatureCollection features = source.getFeatures();
        System.out.println("Slurping in features ...");
        features.accepts(new FeatureVisitor((SpatialIndex)index){
            final /* synthetic */ SpatialIndex val$index;
            {
                this.val$index = spatialIndex;
            }

            public void visit(Feature feature) {
                Envelope env;
                SimpleFeature simpleFeature = (SimpleFeature)feature;
                MultiLineString geom = (MultiLineString)simpleFeature.getDefaultGeometry();
                if (geom != null && !(env = geom.getEnvelopeInternal()).isNull()) {
                    this.val$index.insert(env, (Object)new LocationIndexedLine((Geometry)geom));
                }
            }
        }, (ProgressListener)new NullProgressListener());
        int NUM_POINTS = 10000;
        ReferencedEnvelope bounds = features.getBounds();
        Coordinate[] points = new Coordinate[10000];
        Random rand = new Random(file.hashCode());
        for (int i = 0; i < 10000; ++i) {
            points[i] = new Coordinate(bounds.getMinX() + rand.nextDouble() * bounds.getWidth(), bounds.getMinY() + rand.nextDouble() * bounds.getHeight());
        }
        double MAX_SEARCH_DISTANCE = bounds.getSpan(0) / 100.0;
        long DURATION = 5000L;
        int pointsProcessed = 0;
        int pointsSnapped = 0;
        long elapsedTime = 0L;
        long startTime = System.currentTimeMillis();
        while (pointsProcessed < 10000 && (elapsedTime = System.currentTimeMillis() - startTime) < 5000L) {
            Coordinate pt = points[pointsProcessed++];
            Envelope search = new Envelope(pt);
            search.expandBy(MAX_SEARCH_DISTANCE);
            List lines = index.query(search);
            double minDist = MAX_SEARCH_DISTANCE + 1.0E-6;
            Coordinate minDistPoint = null;
            for (LocationIndexedLine line : lines) {
                LinearLocation here;
                Coordinate point = line.extractPoint(here = line.project(pt));
                double dist = point.distance(pt);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minDistPoint = point;
            }
            if (minDistPoint == null) {
                System.out.println(pt + "- X");
                continue;
            }
            System.out.printf("%s - snapped by moving %.4f\n", pt.toString(), minDist);
            ++pointsSnapped;
        }
        System.out.printf("Processed %d points (%.2f points per second). \nSnapped %d points.\n\n", pointsProcessed, 1000.0 * (double)pointsProcessed / (double)elapsedTime, pointsSnapped);
    }
}

