/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.io.FileInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.metadata.iso.citation.TelephoneImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.text.Text;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.ResourceInternationalString;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class MetadataExamples {
    public static void main(String[] args) {
        MetadataExamples examples = new MetadataExamples();
        examples.exampleRange();
        examples.referenceDocument(Citations.EPSG);
        examples.referenceDocument(Citations.OGC);
        examples.referenceDocument(Citations.ORACLE);
        examples.exampleCitation(examples);
        examples.telephone();
        examples.wkt();
    }

    private void exampleUtilities() {
        Object string1 = null;
        Object string2 = null;
        Object object = null;
        Object value = null;
        int seed = 0;
        Utilities.equals(string1, string2);
        Utilities.equals(null, (Object)"Hello");
        Utilities.equals(null, null);
        Utilities.deepEquals((Object)new double[]{1.0}, (Object)new double[]{1.0});
        Utilities.deepToString((Object)new double[]{1.0, Math.PI, Math.E});
        Utilities.hash(value, (int)seed);
        Utilities.equals(value, object);
        Utilities.ensureNonNull((String)"parameter", object);
    }

    private void exampleCitation(MetadataExamples examples) {
        CitationImpl citation = new CitationImpl();
        citation.setEditionDate(new Date());
        Set<ResponsibleParty> parties = Collections.singleton(ResponsiblePartyImpl.GEOTOOLS);
        citation.setCitedResponsibleParties(parties);
        this.referenceDocument(Citations.ORACLE);
    }

    private void referenceDocument(Citation citation) {
        System.out.println(citation.getTitle());
        System.out.println(citation.getTitle().toString(Locale.FRENCH));
        System.out.println(citation.getIdentifiers());
        System.out.println(citation.getAlternateTitles());
    }

    private void telephone() {
        TelephoneImpl phone = new TelephoneImpl();
        phone.setVoices(Collections.singleton("555-1234"));
        phone.setFacsimiles(Collections.singleton("555-2FAX"));
        System.out.println(phone);
    }

    private void wkt() {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        System.out.println(crs.toWKT());
    }

    private void exampleRange() {
        Range zero = new Range(Double.class, (Comparable)Double.valueOf(0.0));
        System.out.println(zero);
        Range from1to5 = new Range(Double.class, (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(5.0));
        System.out.println(from1to5);
        Range from1upto10 = new Range(Double.class, (Comparable)Double.valueOf(1.0), true, (Comparable)Double.valueOf(10.0), false);
        System.out.println(from1upto10);
        Range between6and8 = new Range(Double.class, (Comparable)Double.valueOf(6.0), false, (Comparable)Double.valueOf(8.0), false);
        System.out.println(between6and8);
        from1to5.getMinValue();
        from1to5.isMinIncluded();
        from1to5.getMaxValue();
        from1to5.isMaxIncluded();
        from1upto10.subtract(between6and8);
        from1upto10.subtract(from1to5);
        from1to5.union(between6and8);
        from1to5.contains((Comparable)Double.valueOf(3.0));
        from1upto10.contains(between6and8);
    }

    private void exampleRangeComparable() {
        Range today = new Range(Date.class, (Comparable)new Date());
    }

    private void exampleNumberRange() {
        NumberRange positive = NumberRange.create((double)0.0, (double)Double.MAX_VALUE);
        NumberRange negative = NumberRange.create((double)0.0, (boolean)false, (double)Double.MIN_VALUE, (boolean)true);
        NumberRange decimal = NumberRange.create((int)1, (int)10);
        positive.contains((Range)decimal);
        positive.contains((Number)3.0);
        positive.contains((Number)3);
    }

    private void examleText() throws Exception {
        InternationalString greeting = Text.text((String)"hello world");
        greeting = Text.text((String)"greeting", (String)"message.properties");
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("greeting", "Hello World");
        translations.put("greeting_it", "ciao mondo");
        greeting = Text.text((String)"greeting", translations);
        Properties properties = new Properties();
        properties.load(new FileInputStream("message.properties"));
        InternationalString title = Text.text((String)"title", (Properties)properties);
        InternationalString description = Text.text((String)"description", (Properties)properties);
    }

    private void exampleResourceInternationalString() {
        ResourceInternationalString greeting = new ResourceInternationalString("message.properties", "greeting");
        System.out.println(greeting);
        System.out.println(greeting.toString(Locale.CANADA_FRENCH));
        ResourceBundle.getBundle("message.properties", Locale.getDefault()).getString("greeting");
    }

    private void exampleSimpleInternationalStirng() {
        SimpleInternationalString greeting = new SimpleInternationalString("Hello World");
        System.out.println(greeting);
        System.out.println(greeting.toString(Locale.FRENCH));
    }

    private void exampleGrowableInternationalString() {
        GrowableInternationalString greeting = new GrowableInternationalString();
        greeting.add(Locale.ENGLISH, "Hello World");
        greeting.add(Locale.FRENCH, "Bonjour tout le monde");
        greeting.add("fr", "greeting", "");
        System.out.println(greeting);
        System.out.println(greeting.toString(Locale.CANADA_FRENCH));
        greeting.add("key_en", "key", "Hello World");
        greeting.add("key_fr", "key", "Bonjour tot le monde");
        GrowableInternationalString cheerfulGreeting = new GrowableInternationalString("G'Day");
        cheerfulGreeting.add(Locale.UK, "Welcome");
        cheerfulGreeting.add(Locale.US, "Hello");
    }
}

