/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.render;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;

public class GenerateSVG {
    private static Logger LOGGER = Logging.getLogger(GenerateSVG.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportSVG(MapContent map, ReferencedEnvelope env, OutputStream out, Dimension canvasSize) throws IOException, ParserConfigurationException {
        SVGGeneratorContext ctx1;
        if (canvasSize == null) {
            canvasSize = new Dimension(300, 300);
        }
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        document = db.getDOMImplementation().createDocument(null, "svg", null);
        SVGGeneratorContext ctx = ctx1 = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated by GeoTools2 with Batik SVG Generator");
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, true);
        g2d.setSVGCanvasSize(canvasSize);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        Rectangle outputArea = new Rectangle(g2d.getSVGCanvasSize());
        ReferencedEnvelope dataArea = map.getMaxBounds();
        LOGGER.finest("rendering map");
        renderer.paint((Graphics2D)g2d, outputArea, dataArea);
        LOGGER.finest("writing to file");
        try (OutputStreamWriter osw = null;){
            osw = new OutputStreamWriter(out, "UTF-8");
            g2d.stream((Writer)osw);
        }
    }
}

