/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.render;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.transform.TransformerException;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.sld.bindings.SLD;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.swing.data.JParameterListWizard;
import org.geotools.util.KVP;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.styling.SLDTransformer;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.opengis.style.Style;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class StyleConverter
extends JFrame {
    private static final String SE_1_1 = "se 1.1";
    private static final String SLD_1_1 = "sld 1.1";
    private static final String SLD_1_0 = "sld 1.0";
    private static final long serialVersionUID = -3407373356333558440L;
    Style style;
    private JTextArea text;
    private ActionListener convertListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (StyleConverter.SLD_1_0.equals(command)) {
                StyleConverter.this.convertToSLD_1_0();
            }
            if (StyleConverter.SLD_1_1.equals(command)) {
                StyleConverter.this.convertToSLD_1_1();
            }
            if (StyleConverter.SE_1_1.equals(command)) {
                StyleConverter.this.convertToSE_1_1();
            }
        }
    };
    private ButtonGroup group;
    private JButton importSLD;
    private JButton importSE;
    private JButton export;
    private JRadioButton sldButton1_0;
    private JRadioButton seButton_1_1;
    private JRadioButton sldButton_1_1;

    public static void main(String ... args) {
        StyleConverter frame = new StyleConverter();
        frame.setVisible(true);
    }

    public StyleConverter() {
        this.setDefaultCloseOperation(3);
        this.text = new JTextArea(40, 80);
        this.sldButton1_0 = new JRadioButton(SLD_1_0);
        this.seButton_1_1 = new JRadioButton(SE_1_1);
        this.sldButton_1_1 = new JRadioButton(SLD_1_0);
        this.group = new ButtonGroup();
        this.group.add(this.sldButton1_0);
        this.group.add(this.seButton_1_1);
        this.group.add(this.sldButton_1_1);
        this.sldButton1_0.addActionListener(this.convertListener);
        this.seButton_1_1.addActionListener(this.convertListener);
        this.sldButton_1_1.addActionListener(this.convertListener);
        this.importSLD = new JButton("Import SLD");
        this.importSLD.setActionCommand("importSLD");
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleConverter.this.style != null) {
                    StyleConverter.this.importSLD();
                }
            }
        });
        this.importSE = new JButton("Import SE");
        this.importSE.setEnabled(false);
        this.export = new JButton("Export");
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StyleConverter.this.style != null) {
                    StyleConverter.this.export();
                }
            }
        });
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[[]][][][grow][]", "[][][][][grow][]"));
        this.getContentPane().add((Component)new JLabel("Format"), "cell 0 0,alignx left,aligny top");
        this.getContentPane().add((Component)this.sldButton1_0, "cell 1 0");
        this.getContentPane().add((Component)this.seButton_1_1, "cell 2 0");
        this.getContentPane().add((Component)this.sldButton_1_1, "cell 3 0");
        this.getContentPane().add((Component)new JLabel("Style"), "cell 0 1,alignx left,aligny top");
        this.getContentPane().add((Component)new JScrollPane(this.text), "cell 0 2 5 5,grow");
        this.getContentPane().add((Component)this.importSLD, "cell 6 2");
        this.getContentPane().add((Component)this.importSE, "cell 6 3");
        this.getContentPane().add((Component)this.export, "cell 6 5");
    }

    private File importStyleWizard(String prompt, String ext, String format) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        list.add(new Parameter("import", File.class, ext, format, (Map)new KVP(new Object[]{"ext", "sld"})));
        JParameterListWizard wizard = new JParameterListWizard("Import Style", prompt, list);
        int finish = wizard.showModalDialog();
        if (finish != 0) {
            return null;
        }
        File file = (File)wizard.getConnectionParameters().get("import");
        return file;
    }

    protected void importSLD() {
        File file = this.importStyleWizard("Select style layer descriptor 1.0 document", "sld", "style layer descriptor");
        if (file == null) {
            return;
        }
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        SLDParser sldParser = new SLDParser(factory);
    }

    protected void export() {
        String format = this.group.getSelection().getActionCommand();
    }

    private void convertToSE_1_1() {
        if (this.style == null) {
            JOptionPane.showMessageDialog(this, "Style not defined");
            return;
        }
        SLDConfiguration configuration = new SLDConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            encoder.encode((Object)this.style, SLD.FEATURETYPESTYLE, (OutputStream)outputStream);
            String document = outputStream.toString("UTF-8");
            this.text.setText(document);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void convertToSLD_1_0() {
        if (this.style == null) {
            JOptionPane.showMessageDialog(this, "Style not defined");
            return;
        }
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        try {
            String document = aTransformer.transform((Object)this.style);
            this.display(document, SLD_1_0);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return;
        }
    }

    private void convertToSLD_1_1() {
        if (this.style == null) {
            JOptionPane.showMessageDialog(this, "Style not defined");
            return;
        }
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = factory.createStyledLayerDescriptor();
        SLDConfiguration configuration = new SLDConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            encoder.encode((Object)this.style, SLD.STYLEDLAYERDESCRIPTOR, (OutputStream)outputStream);
            String document = outputStream.toString("UTF-8");
            this.display(document, SLD_1_1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void display(String document, String format) {
        if (document == null) {
            this.text.setText("<!-- copy or import style document here -->");
            this.seButton_1_1.setSelected(false);
            this.sldButton1_0.setSelected(true);
            this.sldButton_1_1.setSelected(false);
            return;
        }
        this.text.setText(document);
        if (SLD_1_0.equals(format)) {
            this.sldButton1_0.setSelected(true);
        } else if (SLD_1_1.equals(format)) {
            this.sldButton_1_1.setSelected(true);
        } else if (SE_1_1.equals(format)) {
            this.sldButton_1_1.setSelected(true);
        } else {
            this.seButton_1_1.setSelected(false);
            this.sldButton1_0.setSelected(false);
            this.sldButton_1_1.setSelected(false);
        }
    }

    private void readSLD_1_0() {
        StringReader reader;
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        SLDParser sldParser = new SLDParser(factory, (Reader)(reader = new StringReader(this.text.getText())));
        org.geotools.styling.Style[] parsed = sldParser.readXML();
        if (parsed != null && parsed.length > 0) {
            this.style = parsed[0];
        }
    }

    public static StyledLayerDescriptor createDefaultSLD(Style style) {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = factory.createStyledLayerDescriptor();
        UserLayer layer = factory.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle((org.geotools.styling.Style)style);
        return sld;
    }
}

