/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorZoomLevel;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.bing.BingService;
import org.geotools.tile.impl.osm.OSMService;
import org.geotools.tile.impl.osm.OSMTile;
import org.geotools.tile.impl.osm.OSMTileIdentifier;
import org.geotools.tile.util.AsyncTileLayer;
import org.geotools.tile.util.TileLayer;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class TileViewer {
    private JMapFrame frame;

    public TileViewer(String shapeFilename) {
        MapContent map = this.createMap(shapeFilename);
        this.frame = new JMapFrame(map);
        this.frame.setSize(800, 600);
        this.frame.enableStatusBar(true);
        this.frame.enableToolBar(true);
        this.frame.setVisible(true);
    }

    private MapContent createMap(String shapeFilename) {
        MapContent map = new MapContent();
        map.setTitle("TileLab");
        ReferencedEnvelope env = new ReferencedEnvelope(-180.0, 180.0, -80.0, 80.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        env = new ReferencedEnvelope(5.0, 15.0, 45.0, 55.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        try {
            env = env.transform(CRS.decode((String)"EPSG:3857"), true);
        }
        catch (FactoryException | TransformException e1) {
            Logger.getGlobal().log(Level.INFO, "", e1);
        }
        map.getViewport().setBounds(env);
        String baseURL = "http://ak.dynamic.t2.tiles.virtualearth.net/comp/ch/${code}?mkt=de-de&it=G,VE,BX,L,LA&shading=hill&og=78&n=z";
        map.addLayer((Layer)new TileLayer((TileService)new BingService("Road", baseURL)));
        map.addLayer((Layer)new AsyncTileLayer((TileService)new OSMService("Mapnik", "http://tile.openstreetmap.org/")));
        this.createTestCoverageLayer(map);
        if (shapeFilename == null || shapeFilename.endsWith(".shp")) {
            // empty if block
        }
        return map;
    }

    private void createTestCoverageLayer(MapContent map) {
        String baseURL = "http://tile.openstreetmap.org/";
        OSMService service = new OSMService("OSM", baseURL);
        OSMTile t = new OSMTile((TileIdentifier)new OSMTileIdentifier(38596, 49269, (ZoomLevel)new WebMercatorZoomLevel(17), service.getName()), (TileService)service);
        GridCoverageFactory gf = new GridCoverageFactory();
        ReferencedEnvelope env = t.getExtent();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        Style rasterStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
        GridCoverage2D coverage = gf.create((CharSequence)"Factory", (RenderedImage)t.getBufferedImage(), (Envelope)env);
        GridCoverageLayer gcl = new GridCoverageLayer(coverage, rasterStyle);
    }

    private void addTestShape(MapContent map, String shapeFilename) {
        try {
            File shpFile = new File(shapeFilename);
            FileDataStore dataStore = FileDataStoreFinder.getDataStore((File)shpFile);
            SimpleFeatureSource shapefileSource = dataStore.getFeatureSource();
            Style shpStyle = SLD.createPolygonStyle((Color)Color.BLUE, null, (float)0.5f);
            map.addLayer((Layer)new FeatureLayer((FeatureSource)shapefileSource, shpStyle));
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            new TileViewer(args[0]);
        } else {
            new TileViewer(null);
        }
    }
}

