/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.coverage;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Arguments;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImageTiler {
    private final int NUM_HORIZONTAL_TILES = 16;
    private final int NUM_VERTICAL_TILES = 8;
    private Integer numberOfHorizontalTiles = 16;
    private Integer numberOfVerticalTiles = 8;
    private Double tileScale;
    private File inputFile;
    private File outputDirectory;

    private String getFileExtension(File file) {
        String name = file.getName();
        try {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public Integer getNumberOfHorizontalTiles() {
        return this.numberOfHorizontalTiles;
    }

    public void setNumberOfHorizontalTiles(Integer numberOfHorizontalTiles) {
        this.numberOfHorizontalTiles = numberOfHorizontalTiles;
    }

    public Integer getNumberOfVerticalTiles() {
        return this.numberOfVerticalTiles;
    }

    public void setNumberOfVerticalTiles(Integer numberOfVerticalTiles) {
        this.numberOfVerticalTiles = numberOfVerticalTiles;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public Double getTileScale() {
        return this.tileScale;
    }

    public void setTileScale(Double tileScale) {
        this.tileScale = tileScale;
    }

    public static void main(String[] args) throws Exception {
        Arguments processedArgs = new Arguments(args);
        ImageTiler tiler = new ImageTiler();
        try {
            tiler.setInputFile(new File(processedArgs.getRequiredString("-f")));
            tiler.setOutputDirectory(new File(processedArgs.getRequiredString("-o")));
            tiler.setNumberOfHorizontalTiles(processedArgs.getOptionalInteger("-htc"));
            tiler.setNumberOfVerticalTiles(processedArgs.getOptionalInteger("-vtc"));
            tiler.setTileScale(processedArgs.getOptionalDouble("-scale"));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            ImageTiler.printUsage();
            System.exit(1);
        }
        tiler.tile();
    }

    private static void printUsage() {
        System.out.println("Usage: -f inputFile -o outputDirectory [-tw tileWidth<default:256> -th tileHeight<default:256> ");
        System.out.println("-htc horizontalTileCount<default:16> -vtc verticalTileCount<default:8>");
    }

    private GridCoverage2D cropCoverage(GridCoverage2D gridCoverage, Envelope envelope) {
        CoverageProcessor processor = CoverageProcessor.getInstance();
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)gridCoverage);
        param.parameter("Envelope").setValue((Object)envelope);
        return (GridCoverage2D)processor.doOperation(param);
    }

    private Envelope getTileEnvelope(double coverageMinX, double coverageMinY, double geographicTileWidth, double geographicTileHeight, CoordinateReferenceSystem targetCRS, int horizontalIndex, int verticalIndex) {
        double envelopeStartX = (double)horizontalIndex * geographicTileWidth + coverageMinX;
        double envelopeEndX = envelopeStartX + geographicTileWidth;
        double envelopeStartY = (double)verticalIndex * geographicTileHeight + coverageMinY;
        double envelopeEndY = envelopeStartY + geographicTileHeight;
        return new ReferencedEnvelope(envelopeStartX, envelopeEndX, envelopeStartY, envelopeEndY, targetCRS);
    }

    private void tile() throws IOException {
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)this.getInputFile());
        String fileExtension = this.getFileExtension(this.getInputFile());
        Hints hints = null;
        if (format instanceof GeoTiffFormat) {
            hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        }
        AbstractGridCoverage2DReader gridReader = format.getReader((Object)this.getInputFile(), hints);
        GridCoverage2D gridCoverage = gridReader.read(null);
        Envelope2D coverageEnvelope = gridCoverage.getEnvelope2D();
        double coverageMinX = coverageEnvelope.getBounds().getMinX();
        double coverageMaxX = coverageEnvelope.getBounds().getMaxX();
        double coverageMinY = coverageEnvelope.getBounds().getMinY();
        double coverageMaxY = coverageEnvelope.getBounds().getMaxY();
        int htc = this.getNumberOfHorizontalTiles() != null ? this.getNumberOfHorizontalTiles() : 16;
        int vtc = this.getNumberOfVerticalTiles() != null ? this.getNumberOfVerticalTiles() : 8;
        double geographicTileWidth = (coverageMaxX - coverageMinX) / (double)htc;
        double geographicTileHeight = (coverageMaxY - coverageMinY) / (double)vtc;
        CoordinateReferenceSystem targetCRS = gridCoverage.getCoordinateReferenceSystem();
        File tileDirectory = this.getOutputDirectory();
        if (!tileDirectory.exists()) {
            tileDirectory.mkdirs();
        }
        for (int i = 0; i < htc; ++i) {
            for (int j = 0; j < vtc; ++j) {
                System.out.println("Processing tile at indices i: " + i + " and j: " + j);
                Envelope envelope = this.getTileEnvelope(coverageMinX, coverageMinY, geographicTileWidth, geographicTileHeight, targetCRS, i, j);
                GridCoverage2D finalCoverage = this.cropCoverage(gridCoverage, envelope);
                if (this.getTileScale() != null) {
                    finalCoverage = this.scaleCoverage(finalCoverage);
                }
                File tileFile = new File(tileDirectory, i + "_" + j + "." + fileExtension);
                format.getWriter((Object)tileFile).write((GridCoverage)finalCoverage, null);
            }
        }
    }

    private GridCoverage2D scaleCoverage(GridCoverage2D coverage) {
        Operations ops = new Operations(null);
        coverage = (GridCoverage2D)ops.scale((GridCoverage)coverage, this.getTileScale().doubleValue(), this.getTileScale().doubleValue(), 0.0, 0.0);
        return coverage;
    }
}

