/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv2;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.tutorial.csv2.CSVDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class CSVDataStoreFactory
implements DataStoreFactorySpi {
    Boolean isAvailable = null;
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "Comma seperated value file", true, null, (Map)new KVP(new Object[]{"ext", "csv"}));
    private static final Logger LOGGER = Logging.getLogger(CSVDataStoreFactory.class);

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public String getDisplayName() {
        return "CSV";
    }

    public String getDescription() {
        return "Comma delimited text file.";
    }

    public synchronized boolean isAvailable() {
        if (this.isAvailable == null) {
            try {
                Class<?> cvsReaderType = Class.forName("com.csvreader.CsvReader");
                this.isAvailable = cvsReaderType != null;
            }
            catch (ClassNotFoundException e) {
                this.isAvailable = false;
            }
        }
        return this.isAvailable;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM};
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            File file = (File)FILE_PARAM.lookUp(params);
            if (file != null) {
                return file.getPath().toLowerCase().endsWith(".csv");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        File file = (File)FILE_PARAM.lookUp(params);
        return new CSVDataStore(file);
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        File file = (File)FILE_PARAM.lookUp(params);
        if (file.exists()) {
            LOGGER.warning("File already exsists: " + file);
        }
        return new CSVDataStore(file);
    }
}

