/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv2;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tutorial.csv2.CSVDataStore;
import org.geotools.tutorial.csv2.CSVFeatureReader;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.cs.AxisDirection;

public class CSVFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private CSVFeatureReader delegate;
    private File temp;
    private CsvWriter csvWriter;
    private SimpleFeature currentFeature;
    private boolean appending = false;
    private boolean latlon = DefaultGeographicCRS.WGS84.getCoordinateSystem().getAxis(0).getDirection().equals((Object)AxisDirection.NORTH);
    int latIndex = 0;
    int lngIndex = 0;
    int nextRow = 0;

    public CSVFeatureWriter(ContentState state, Query query) throws IOException {
        this.state = state;
        String typeName = query.getTypeName();
        File file = ((CSVDataStore)state.getEntry().getDataStore()).file;
        File directory = file.getParentFile();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "csv", directory);
        this.csvWriter = new CsvWriter((Writer)new FileWriter(this.temp), ',');
        this.delegate = new CSVFeatureReader(state, query);
        this.csvWriter.writeRecord(this.delegate.reader.getHeaders());
        String latField = "lat";
        String lngField = "lon";
        String[] headers = this.delegate.reader.getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i].equalsIgnoreCase(latField)) {
                this.latIndex = i;
            }
            if (!headers[i].equalsIgnoreCase(lngField)) continue;
            this.lngIndex = i;
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        if (this.csvWriter == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.delegate.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.csvWriter == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.delegate.reader != null && this.delegate.hasNext()) {
                    this.currentFeature = this.delegate.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            SimpleFeatureType featureType = this.state.getFeatureType();
            String fid = featureType.getTypeName() + "." + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    public void remove() throws IOException {
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        for (Property property : this.currentFeature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                this.csvWriter.write("");
                continue;
            }
            if (value instanceof Point) {
                Point point = (Point)value;
                if (this.latlon && this.latIndex <= this.lngIndex) {
                    this.csvWriter.write(Double.toString(point.getX()));
                    this.csvWriter.write(Double.toString(point.getY()));
                    continue;
                }
                this.csvWriter.write(Double.toString(point.getY()));
                this.csvWriter.write(Double.toString(point.getX()));
                continue;
            }
            String txt = value.toString();
            this.csvWriter.write(txt);
        }
        this.csvWriter.endRecord();
        ++this.nextRow;
        this.currentFeature = null;
    }

    public void close() throws IOException {
        if (this.csvWriter == null) {
            throw new IOException("Writer alread closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        while (this.hasNext()) {
            this.next();
            this.write();
        }
        this.csvWriter.close();
        this.csvWriter = null;
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        File file = ((CSVDataStore)this.state.getEntry().getDataStore()).file;
        Files.copy(this.temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

