/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.tutorial.csv3.CSVDataStore;
import org.geotools.tutorial.csv3.CSVFeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class CSVFeatureSource
extends ContentFeatureSource {
    public CSVFeatureSource(CSVDataStore datastore) {
        this(datastore, Query.ALL);
    }

    public CSVFeatureSource(CSVDataStore datastore, Query query) {
        this(new ContentEntry((ContentDataStore)datastore, datastore.getTypeName()), query);
    }

    public CSVFeatureSource(ContentEntry entry) {
        this(entry, Query.ALL);
    }

    public CSVFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public CSVDataStore getDataStore() {
        return (CSVDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
        try (FeatureReader featureReader = this.getReader(query);){
            while (featureReader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureReader.next();
                bounds.include(feature.getBounds());
            }
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        int n = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
            n = 0;
            while (featureReader.hasNext()) {
                featureReader.next();
                ++n;
            }
        }
        return n;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        CSVDataStore dataStore = this.getDataStore();
        return new CSVFeatureReader(dataStore.getCSVStrategy(), query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.getDataStore().getSchema();
    }
}

