/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.tutorial.csv3.CSVDataStore;
import org.geotools.tutorial.csv3.CSVFeatureSource;
import org.geotools.tutorial.csv3.CSVFeatureWriter;
import org.geotools.tutorial.csv3.CSVFileState;
import org.geotools.tutorial.csv3.parse.CSVStrategy;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class CSVFeatureStore
extends ContentFeatureStore {
    private CSVStrategy csvStrategy;
    private CSVFileState csvFileState;
    CSVFeatureSource delegate;

    public CSVFeatureStore(CSVStrategy csvStrategy, CSVFileState csvFileState, ContentEntry entry, Query query) {
        super(entry, query);
        this.delegate = new CSVFeatureSource(this.entry, this.query){

            public void setTransaction(Transaction transaction) {
                super.setTransaction(transaction);
                CSVFeatureStore.this.setTransaction(transaction);
            }
        };
        this.csvStrategy = csvStrategy;
        this.csvFileState = csvFileState;
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        return new CSVFeatureWriter(this.csvFileState, this.csvStrategy, query);
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    public CSVDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public ContentState getState() {
        return this.delegate.getState();
    }

    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }
}

