/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.tutorial.csv.CSVTest;
import org.geotools.tutorial.csv3.CSVDataStoreFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class CSVWriteTest {
    File tmp;
    File file;

    @Before
    public void createTemporaryLocations() throws IOException {
        boolean created;
        System.setProperty("org.geotools.referencing.forceXY", "true");
        this.tmp = File.createTempFile("example", "");
        boolean exists = this.tmp.exists();
        if (exists) {
            System.err.println("Removing tempfile " + this.tmp);
            this.tmp.delete();
        }
        if (!(created = this.tmp.mkdirs())) {
            System.err.println("Could not create " + this.tmp);
            System.exit(1);
        }
        this.file = new File(this.tmp, "locations.csv");
        URL resource = CSVTest.class.getResource("locations.csv");
        Files.copy(resource.openStream(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void fileContents(String test, File modified) throws IOException {
        System.out.println(test + " contents start");
        Files.copy(modified.toPath(), System.out);
        System.out.println(test + " contents end");
    }

    @After
    public void removeTemporaryLocations() throws IOException {
        File[] list = this.tmp.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                list[i].delete();
            }
        }
        this.tmp.delete();
    }

    @Test
    public void featureStoreExample() throws Exception {
        System.out.println("featureStoreExample start\n");
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", this.file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureSource featureSource = store.getFeatureSource("locations");
        if (!(featureSource instanceof SimpleFeatureStore)) {
            throw new IllegalStateException("Modification not supported");
        }
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        System.out.println("\nfeatureStoreExample end\n");
    }

    @Test
    public void transactionExample() throws Exception {
        System.out.println("transactionExample start\n");
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", this.file);
        DataStore store = DataStoreFinder.getDataStore(params);
        DefaultTransaction t1 = new DefaultTransaction("transaction 1");
        DefaultTransaction t2 = new DefaultTransaction("transactoin 2");
        SimpleFeatureType type = store.getSchema("locations");
        SimpleFeatureStore featureStore = (SimpleFeatureStore)store.getFeatureSource("locations");
        SimpleFeatureStore featureStore1 = (SimpleFeatureStore)store.getFeatureSource("locations");
        SimpleFeatureStore featureStore2 = (SimpleFeatureStore)store.getFeatureSource("locations");
        featureStore1.setTransaction((Transaction)t1);
        featureStore2.setTransaction((Transaction)t2);
        System.out.println("Step 1");
        System.out.println("------");
        System.out.println("start     auto-commit: " + DataUtilities.fidSet((FeatureCollection)featureStore.getFeatures()));
        System.out.println("start              t1: " + DataUtilities.fidSet((FeatureCollection)featureStore1.getFeatures()));
        System.out.println("start              t2: " + DataUtilities.fidSet((FeatureCollection)featureStore2.getFeatures()));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Id filter1 = ff.id(Collections.singleton(ff.featureId("fid1")));
        featureStore1.removeFeatures((Filter)filter1);
        System.out.println();
        System.out.println("Step 2 transaction 1 removes feature 'fid1'");
        System.out.println("------");
        System.out.println("t1 remove auto-commit: " + DataUtilities.fidSet((FeatureCollection)featureStore.getFeatures()));
        System.out.println("t1 remove          t1: " + DataUtilities.fidSet((FeatureCollection)featureStore1.getFeatures()));
        System.out.println("t1 remove          t2: " + DataUtilities.fidSet((FeatureCollection)featureStore2.getFeatures()));
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        Point boston = gf.createPoint(new Coordinate(-71.0589, 42.3601));
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{boston, "Boston", 1300, 2017}, (String)"locations.1");
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)feature);
        featureStore2.addFeatures((FeatureCollection)collection);
        System.out.println();
        System.out.println("Step 3 transaction 2 adds a new feature '" + feature.getID() + "'");
        System.out.println("------");
        System.out.println("t2 add    auto-commit: " + DataUtilities.fidSet((FeatureCollection)featureStore.getFeatures()));
        System.out.println("t2 add             t1: " + DataUtilities.fidSet((FeatureCollection)featureStore1.getFeatures()));
        System.out.println("t1 add             t2: " + DataUtilities.fidSet((FeatureCollection)featureStore2.getFeatures()));
        t1.commit();
        System.out.println();
        System.out.println("Step 4 transaction 1 commits the removal of feature 'fid1'");
        System.out.println("------");
        System.out.println("t1 commit auto-commit: " + DataUtilities.fidSet((FeatureCollection)featureStore.getFeatures()));
        System.out.println("t1 commit          t1: " + DataUtilities.fidSet((FeatureCollection)featureStore1.getFeatures()));
        System.out.println("t1 commit          t2: " + DataUtilities.fidSet((FeatureCollection)featureStore2.getFeatures()));
        t2.commit();
        System.out.println();
        System.out.println("Step 5 transaction 2 commits the addition of '" + feature.getID() + "'");
        System.out.println("------");
        System.out.println("t2 commit auto-commit: " + DataUtilities.fidSet((FeatureCollection)featureStore.getFeatures()));
        System.out.println("t2 commit          t1: " + DataUtilities.fidSet((FeatureCollection)featureStore1.getFeatures()));
        System.out.println("t2 commit          t2: " + DataUtilities.fidSet((FeatureCollection)featureStore2.getFeatures()));
        t1.close();
        t2.close();
        store.dispose();
        System.out.println("\ntransactionExample end\n");
        this.fileContents("transactionExample", this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeAllExample() throws Exception {
        System.out.println("removeAllExample start\n");
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", this.file);
        DataStore store = DataStoreFinder.getDataStore(params);
        DefaultTransaction t = new DefaultTransaction("locations");
        try {
            try (FeatureWriter writer = store.getFeatureWriter("locations", (Filter)Filter.INCLUDE, (Transaction)t);){
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    System.out.println("remove " + feature.getID());
                    writer.remove();
                }
            }
            System.out.println("commit " + t);
            t.commit();
        }
        catch (Throwable eek) {
            t.rollback();
        }
        finally {
            t.close();
            store.dispose();
        }
        System.out.println("\nremoveAllExample end\n");
        this.fileContents("removeAllExample", this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replaceAll() throws Exception {
        System.out.println("replaceAll start\n");
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", this.file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureType type = store.getSchema("locations");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        Point boston = gf.createPoint(new Coordinate(-71.0589, 42.3601));
        SimpleFeature bf = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{boston, "Boston", 1300, 2017}, (String)"locations.1");
        collection.add(bf);
        try (FeatureWriter writer = store.getFeatureWriter("locations", Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
            SimpleFeatureIterator iterator = collection.features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                newFeature.setAttributes(feature.getAttributes());
                writer.write();
            }
        }
        System.out.println("\nreplaceAll end\n");
        this.fileContents("replaceAll", this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appendContent() throws Exception {
        System.out.println("appendContent start\n");
        File directory = this.tmp;
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", this.file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureType featureType = store.getSchema("locations");
        File file2 = new File(directory, "duplicate.rst");
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("file", file2);
        CSVDataStoreFactory factory = new CSVDataStoreFactory();
        DataStore duplicate = factory.createNewDataStore(params2);
        duplicate.createSchema((FeatureType)featureType);
        Query query = new Query(featureType.getTypeName(), (Filter)Filter.INCLUDE);
        FeatureReader reader = store.getFeatureReader(query, Transaction.AUTO_COMMIT);
        FeatureWriter writer = duplicate.getFeatureWriterAppend("duplicate", Transaction.AUTO_COMMIT);
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                newFeature.setAttributes(feature.getAttributes());
                writer.write();
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        System.out.println("\nappendContent end\n");
        this.fileContents("appendContent", file2);
    }
}

