/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3.parse;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.tutorial.csv3.CSVFileState;
import org.geotools.tutorial.csv3.parse.CSVStrategy;
import org.opengis.feature.simple.SimpleFeature;

public class CSVIterator
implements Iterator<SimpleFeature> {
    private int idx;
    private SimpleFeature next;
    private final CsvReader csvReader;
    private final CSVStrategy csvStrategy;

    public CSVIterator(CSVFileState csvFileState, CSVStrategy csvStrategy) throws IOException {
        this.csvStrategy = csvStrategy;
        this.csvReader = csvFileState.openCSVReader();
        this.idx = 1;
        this.next = null;
    }

    private SimpleFeature buildFeature(String[] csvRecord) {
        String id = "fid" + this.idx;
        SimpleFeature feature = this.csvStrategy.decode(id, csvRecord);
        ++this.idx;
        return feature;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.readFeature();
        }
        catch (IOException e) {
            this.next = null;
        }
        return this.next != null;
    }

    private SimpleFeature readFeature() throws IOException {
        if (this.csvReader.readRecord()) {
            String[] csvRecord = this.csvReader.getValues();
            return this.buildFeature(csvRecord);
        }
        return null;
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature feature;
        if (this.next != null) {
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }
        try {
            feature = this.readFeature();
        }
        catch (IOException e) {
            feature = null;
        }
        if (feature == null) {
            throw new NoSuchElementException();
        }
        return feature;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove features from csv iteratore");
    }

    public void close() {
        this.csvReader.close();
    }
}

