/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.UIManager;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Csv2Shape {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        File file = JFileDataStoreChooser.showOpenFile((String)"csv", null);
        if (file == null) {
            return;
        }
        SimpleFeatureType TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:Point:srid=4326,name:String,number:Integer");
        System.out.println("TYPE:" + TYPE);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            System.out.println("Header: " + line);
            line = reader.readLine();
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] tokens = line.split("\\,");
                    double latitude = Double.parseDouble(tokens[0]);
                    double longitude = Double.parseDouble(tokens[1]);
                    String name = tokens[2].trim();
                    int number = Integer.parseInt(tokens[3].trim());
                    Point point = geometryFactory.createPoint(new Coordinate(longitude, latitude));
                    featureBuilder.add((Object)point);
                    featureBuilder.add((Object)name);
                    featureBuilder.add((Object)number);
                    SimpleFeature feature = featureBuilder.buildFeature(null);
                    features.add(feature);
                }
                line = reader.readLine();
            }
        }
        File newFile = Csv2Shape.getNewShapeFile(file);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        SimpleFeatureType SHAPE_TYPE = (SimpleFeatureType)featureSource.getSchema();
        System.out.println("SHAPE:" + SHAPE_TYPE);
        if (featureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            ListFeatureCollection collection = new ListFeatureCollection(TYPE, features);
            featureStore.setTransaction((Transaction)transaction);
            try {
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                problem.printStackTrace();
                transaction.rollback();
            }
            finally {
                transaction.close();
            }
            System.exit(0);
        } else {
            System.out.println(typeName + " does not support read/write access");
            System.exit(1);
        }
    }

    private static File getNewShapeFile(File csvFile) {
        File newFile;
        String path = csvFile.getAbsolutePath();
        String newPath = path.substring(0, path.length() - 4) + ".shp";
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save shapefile");
        chooser.setSelectedFile(new File(newPath));
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            System.exit(0);
        }
        if ((newFile = chooser.getSelectedFile()).equals(csvFile)) {
            System.out.println("Error: cannot replace " + csvFile);
            System.exit(0);
        }
        return newFile;
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", Point.class);
        builder.length(15).add("Name", String.class);
        builder.add("number", Integer.class);
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        return LOCATION;
    }
}

