/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.swing.action.SafeAction;
import org.geotools.swing.data.JDataStoreWizard;
import org.geotools.swing.table.FeatureCollectionTableModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class QueryLab
extends JFrame {
    private DataStore dataStore;
    private JComboBox<String> featureTypeCBox;
    private JTable table;
    private JTextField text;

    public static void main(String[] args) throws Exception {
        QueryLab frame = new QueryLab();
        frame.setVisible(true);
    }

    public QueryLab() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.text = new JTextField(80);
        this.text.setText("include");
        this.getContentPane().add((Component)this.text, "North");
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        this.table.setModel(new DefaultTableModel(5, 5));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)scrollPane, "Center");
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu fileMenu = new JMenu("File");
        menubar.add(fileMenu);
        this.featureTypeCBox = new JComboBox();
        menubar.add(this.featureTypeCBox);
        JMenu dataMenu = new JMenu("Data");
        menubar.add(dataMenu);
        this.pack();
        fileMenu.add((Action)new SafeAction("Open shapefile..."){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.connect((DataStoreFactorySpi)new ShapefileDataStoreFactory());
            }
        });
        fileMenu.add((Action)new SafeAction("Connect to PostGIS database..."){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.connect((DataStoreFactorySpi)new PostgisNGDataStoreFactory());
            }
        });
        fileMenu.add((Action)new SafeAction("Connect to DataStore..."){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.connect(null);
            }
        });
        fileMenu.addSeparator();
        fileMenu.add((Action)new SafeAction("Exit"){

            public void action(ActionEvent e) throws Throwable {
                System.exit(0);
            }
        });
        dataMenu.add((Action)new SafeAction("Get features"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.filterFeatures();
            }
        });
        dataMenu.add((Action)new SafeAction("Count"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.countFeatures();
            }
        });
        dataMenu.add((Action)new SafeAction("Geometry"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.queryFeatures();
            }
        });
        dataMenu.add((Action)new SafeAction("Center"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.centerFeatures();
            }
        });
    }

    private void connect(DataStoreFactorySpi format) throws Exception {
        JDataStoreWizard wizard = new JDataStoreWizard(format);
        int result = wizard.showModalDialog();
        if (result == 0) {
            Map connectionParameters = wizard.getConnectionParameters();
            this.dataStore = DataStoreFinder.getDataStore((Map)connectionParameters);
            if (this.dataStore == null) {
                JOptionPane.showMessageDialog(null, "Could not connect - check parameters");
            }
            this.updateUI();
        }
    }

    private void updateUI() throws Exception {
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(this.dataStore.getTypeNames());
        this.featureTypeCBox.setModel(cbm);
        this.table.setModel(new DefaultTableModel(5, 5));
    }

    private void filterFeatures() throws Exception {
        String typeName = (String)this.featureTypeCBox.getSelectedItem();
        SimpleFeatureSource source = this.dataStore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        SimpleFeatureCollection features = source.getFeatures(filter);
        FeatureCollectionTableModel model = new FeatureCollectionTableModel(features);
        this.table.setModel((TableModel)model);
    }

    private void countFeatures() throws Exception {
        String typeName = (String)this.featureTypeCBox.getSelectedItem();
        SimpleFeatureSource source = this.dataStore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        SimpleFeatureCollection features = source.getFeatures(filter);
        int count = features.size();
        JOptionPane.showMessageDialog(this.text, "Number of selected features:" + count);
    }

    private void queryFeatures() throws Exception {
        String typeName = (String)this.featureTypeCBox.getSelectedItem();
        SimpleFeatureSource source = this.dataStore.getFeatureSource(typeName);
        FeatureType schema = source.getSchema();
        String name = schema.getGeometryDescriptor().getLocalName();
        Filter filter = CQL.toFilter((String)this.text.getText());
        Query query = new Query(typeName, filter, new String[]{name});
        SimpleFeatureCollection features = source.getFeatures(query);
        FeatureCollectionTableModel model = new FeatureCollectionTableModel(features);
        this.table.setModel((TableModel)model);
    }

    private void centerFeatures() throws Exception {
        String typeName = (String)this.featureTypeCBox.getSelectedItem();
        SimpleFeatureSource source = this.dataStore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        FeatureType schema = source.getSchema();
        String name = schema.getGeometryDescriptor().getLocalName();
        Query query = new Query(typeName, filter, new String[]{name});
        SimpleFeatureCollection features = source.getFeatures(query);
        double totalX = 0.0;
        double totalY = 0.0;
        long count = 0L;
        try (SimpleFeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Point centroid = geom.getCentroid();
                totalX += centroid.getX();
                totalY += centroid.getY();
                ++count;
            }
        }
        double averageX = totalX / (double)count;
        double averageY = totalY / (double)count;
        Coordinate center = new Coordinate(averageX, averageY);
        JOptionPane.showMessageDialog(this.text, "Center of selected features:" + center);
    }
}

