/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.function;

import java.util.Collections;
import java.util.List;
import org.geotools.util.Converters;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public abstract class AbstractFunction
implements Function {
    protected final FunctionName name;
    protected final List<Expression> params;
    protected final Literal fallback;

    protected AbstractFunction(FunctionName name, List<Expression> args, Literal fallback) {
        this.name = name;
        this.params = args;
        this.fallback = fallback;
    }

    public abstract Object evaluate(Object var1);

    public <T> T evaluate(Object object, Class<T> context) {
        Object value = this.evaluate(object);
        return (T)Converters.convert((Object)value, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return this.name.getName();
    }

    public FunctionName getFunctionName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.params);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    <T> T eval(Object feature, int index, Class<T> type) {
        Expression expr = this.params.get(index);
        Object value = expr.evaluate(feature, type);
        return type.cast(value);
    }
}

