/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.function;

import java.util.List;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;

public class SnapFunction
implements Function {
    static FunctionName NAME = new FunctionNameImpl("snap", Point.class, new Parameter[]{FunctionNameImpl.parameter((String)"point", Point.class), FunctionNameImpl.parameter((String)"line", Geometry.class)});
    private final List<Expression> parameters;
    private final Literal fallback;

    public SnapFunction(List<Expression> parameters, Literal fallback) {
        if (parameters == null) {
            throw new NullPointerException("parameters required");
        }
        if (parameters.size() != 2) {
            throw new IllegalArgumentException("snap( point, line) requires two parameters only");
        }
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Point.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression pointExpression = this.parameters.get(0);
        Point point = (Point)pointExpression.evaluate(object, Point.class);
        Expression lineExpression = this.parameters.get(1);
        Geometry line = (Geometry)lineExpression.evaluate(object, Geometry.class);
        LocationIndexedLine index = new LocationIndexedLine(line);
        LinearLocation location = index.project(point.getCoordinate());
        Coordinate snap = index.extractPoint(location);
        Point pt = point.getFactory().createPoint(snap);
        return (T)Converters.convert((Object)pt, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

