/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.process;

import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.feature.FeatureToFeatureProcess;
import org.geotools.process.feature.FeatureToFeatureProcessFactory;
import org.geotools.tutorial.process.BufferFeatureCollectionFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class BufferFeatureCollectionProcess
extends FeatureToFeatureProcess {
    public BufferFeatureCollectionProcess(BufferFeatureCollectionFactory factory) {
        super((FeatureToFeatureProcessFactory)factory);
    }

    protected void processFeature(SimpleFeature feature, Map<String, Object> input) throws Exception {
        Double buffer = (Double)input.get(BufferFeatureCollectionFactory.BUFFER.key);
        Geometry g = (Geometry)feature.getDefaultGeometry();
        if ((g = g.buffer(buffer.doubleValue())) instanceof Polygon) {
            g = g.getFactory().createMultiPolygon(new Polygon[]{(Polygon)g});
        }
        feature.setDefaultGeometry((Object)g);
    }

    protected SimpleFeatureType getTargetSchema(SimpleFeatureType sourceSchema, Map<String, Object> input) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        for (AttributeDescriptor ad : sourceSchema.getAttributeDescriptors()) {
            GeometryDescriptor defaultGeometry;
            if (ad == (defaultGeometry = sourceSchema.getGeometryDescriptor())) {
                tb.add(ad.getName().getLocalPart(), MultiPolygon.class, defaultGeometry.getCoordinateReferenceSystem());
                continue;
            }
            tb.add(ad);
        }
        tb.setName(sourceSchema.getName());
        return tb.buildFeatureType();
    }
}

