/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterFeature;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerFeature;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.gml2.ApplicationSchemaXSD;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.wfs.gtxml.GTXML;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.YourCode;
import org.geotools.xml.gml.GMLComplexTypes;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Schema;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.XSD;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class GMLExamples {
    private void saxExample() throws Exception {
        InputSource input = null;
        YourCode handler = new YourCode();
        GMLFilterFeature filterFeature = new GMLFilterFeature((GMLHandlerFeature)handler);
        GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFeature);
        GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
        XMLReader reader = this.getXMLReader();
        reader.setContentHandler((ContentHandler)filterDocument);
        reader.parse(input);
        List<SimpleFeature> features = handler.getFeatures();
    }

    private void saxExample2() throws Exception {
        InputSource input = null;
        class InlineHandler
        extends XMLFilterImpl
        implements GMLHandlerFeature {
            List<SimpleFeature> features = new ArrayList<SimpleFeature>();

            InlineHandler() {
            }

            public void feature(SimpleFeature feature) {
                this.features.add(feature);
            }
        }
        InlineHandler inlineHandler = new InlineHandler();
        GMLFilterFeature filterFeature = new GMLFilterFeature((GMLHandlerFeature)inlineHandler);
        GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFeature);
        GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
        XMLReader reader = this.getXMLReader();
        reader.setContentHandler((ContentHandler)filterDocument);
        reader.parse(input);
        List<SimpleFeature> features = inlineHandler.features;
    }

    private void transformExample() throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"urn:org.geotools.xml.examples", (String)"location", (String)"geom:Point,name:String");
        TYPE.getUserData().put("prefix", "ex");
        WKTReader2 wkt = new WKTReader2();
        LinkedList<SimpleFeature> collection = new LinkedList<SimpleFeature>();
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)TYPE, (Object[])new Object[]{wkt.read("POINT (1 2)"), "name1"}, null));
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)TYPE, (Object[])new Object[]{wkt.read("POINT (4 4)"), "name2"}, null));
        ListFeatureCollection featureCollection = new ListFeatureCollection(TYPE, collection);
        FeatureTransformer transform = new FeatureTransformer();
        transform.setEncoding(Charset.defaultCharset());
        transform.setIndentation(4);
        transform.setGmlPrefixing(true);
        SimpleFeatureType schema = (SimpleFeatureType)featureCollection.getSchema();
        String prefix = (String)schema.getUserData().get("prefix");
        String namespace = schema.getName().getNamespaceURI();
        transform.getFeatureTypeNamespaces().declareDefaultNamespace(prefix, namespace);
        transform.addSchemaLocation(prefix, namespace);
        String srsName = CRS.toSRS((CoordinateReferenceSystem)schema.getCoordinateReferenceSystem());
        if (srsName != null) {
            transform.setSrsName(srsName);
        }
        transform.setCollectionPrefix("col");
        transform.setCollectionNamespace("urn:org.geotools.xml.example.collection");
        transform.setCollectionBounding(true);
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        transform.transform((Object)featureCollection, (OutputStream)xml);
        xml.close();
        System.out.println(xml.toString());
    }

    private void transformExample2() throws Exception {
        Object fc = null;
        OutputStream out = null;
        SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
        FeatureTransformer tx = new FeatureTransformer();
        String srsName = CRS.toSRS((CoordinateReferenceSystem)ft.getCoordinateReferenceSystem(), (boolean)true);
        tx.setSrsName(srsName);
        String namespaceURI = ft.getName().getNamespaceURI();
        tx.getFeatureTypeNamespaces().declareNamespace((FeatureType)ft, "wps", namespaceURI);
        Schema s = SchemaFactory.getInstance((String)namespaceURI);
        tx.addSchemaLocation(namespaceURI, s.getURI().toASCIIString());
        tx.transform(fc, out);
    }

    private void xdoExample() throws Exception {
        XMLReader reader = this.getXMLReader();
        URI schemaLoc = new URI("http://giswebservices.massgis.state.ma.us/geoserver/wfs?request=describefeaturetype&service=wfs&version=1.0.0&typename=massgis:GISDATA.COUNTIES_POLY");
        XSISAXHandler schemaHandler = new XSISAXHandler(schemaLoc);
        reader.setContentHandler((ContentHandler)schemaHandler);
        reader.parse(new InputSource(new URL(schemaLoc.toString()).openConnection().getInputStream()));
        SimpleFeatureType ft = GMLComplexTypes.createFeatureType((Element)schemaHandler.getSchema().getElements()[0]);
    }

    private XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        return parser.getXMLReader();
    }

    private void rawSchemaExample() throws Exception {
        Object typeName = null;
        URL schemaLocation = null;
        CoordinateReferenceSystem crs = null;
        QName featureName = new QName(typeName.getNamespaceURI(), typeName.getLocalPart());
        String namespaceURI = featureName.getNamespaceURI();
        String uri = schemaLocation.toExternalForm();
        ApplicationSchemaConfiguration wfsConfiguration = new ApplicationSchemaConfiguration(namespaceURI, uri);
        FeatureType parsed = GTXML.parseFeatureType((Configuration)wfsConfiguration, (QName)featureName, crs);
        SimpleFeatureType schema = DataUtilities.simple((FeatureType)parsed);
    }

    private void rawSchemaExample2() throws Exception {
        Object typeName = null;
        URL schemaLocation = null;
        CoordinateReferenceSystem crs = null;
        QName featureName = new QName(typeName.getNamespaceURI(), typeName.getLocalPart());
        String namespaceURI = featureName.getNamespaceURI();
        String uri = schemaLocation.toExternalForm();
        ApplicationSchemaXSD xsd = new ApplicationSchemaXSD(namespaceURI, uri);
        Configuration configuration = new Configuration((XSD)xsd){
            {
                this.addDependency((Configuration)new XSConfiguration());
                this.addDependency((Configuration)new GMLConfiguration());
            }

            protected void registerBindings(Map bindings) {
            }
        };
        FeatureType parsed = GTXML.parseFeatureType((Configuration)configuration, (QName)featureName, crs);
        SimpleFeatureType schema = DataUtilities.simple((FeatureType)parsed);
    }
}

