/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2004-2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.geotools.api.metadata.extent;

/**
 * Base interface for geographic area of the dataset.
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/as#01-111">ISO 19115</A>
 * @author Martin Desruisseaux (IRD)
 * @author Cory Horner (Refractions Research)
 * @since GeoAPI 1.0
 */
public interface GeographicExtent {
    /**
     * Indication of whether the bounding polygon encompasses an area covered by the data (<cite>inclusion</cite>) or an
     * area where data is not present (<cite>exclusion</cite>).
     *
     * @return {@code true} for inclusion, {@code false} for exclusion, or {@code null} if unspecified.
     */
    Boolean getInclusion();
}
