/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.wfs.PropertyValueCollection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.util.Stopwatch;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class FeatureChainingTest
extends AppSchemaTestSupport {
    public static final String GSMLNS = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    public static final String GMLNS = "http://www.opengis.net/gml";
    public static final String XLINKNS = "http://www.w3.org/1999/xlink";
    static final Name MAPPED_FEATURE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeatureType");
    static final Name MAPPED_FEATURE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
    static final Name GEOLOGIC_UNIT_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnitType");
    static final Name GEOLOGIC_UNIT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnit");
    static final Name GEOLOGIC_UNIT_NAME = Types.typeName((String)"myGeologicUnit");
    static final Name COMPOSITION_PART_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CompositionPartType");
    static final Name COMPOSITION_PART = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CompositionPart");
    static final Name CGI_TERM_VALUE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CGI_TermValue");
    static final Name CGI_TERM_VALUE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CGI_TermValueType");
    static final Name CONTROLLED_CONCEPT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"ControlledConcept");
    static FilterFactory2 ff;
    private NamespaceSupport namespaces = new NamespaceSupport();
    static final Map<String, String> mfToGuMap;
    static final Map<String, String> guToCpMap;
    static final Map<String, String> guToExposureColorMap;
    static Map<String, String> guToOutcropCharacterMap;
    private static final String schemaBase = "/test-data/";
    private static FeatureSource<FeatureType, Feature> mfSource;
    private static FeatureCollection<FeatureType, Feature> mfFeatures;
    private static FeatureCollection<FeatureType, Feature> guFeatures;
    private static FeatureCollection<FeatureType, Feature> cpFeatures;
    private static FeatureCollection<FeatureType, Feature> ccFeatures;

    public FeatureChainingTest() {
        this.namespaces.declarePrefix("gml", GMLNS);
        this.namespaces.declarePrefix("gsml", GSMLNS);
        this.namespaces.declarePrefix("xlink", XLINKNS);
        ff = new FilterFactoryImplNamespaceAware(this.namespaces);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Stopwatch sw = new Stopwatch();
        sw.start();
        FeatureChainingTest.loadDataAccesses();
        sw.stop();
    }

    @Test
    public void testFeatureChaining() throws Exception {
        try (FeatureIterator mfIterator = mfFeatures.features();
             FeatureIterator guIterator = guFeatures.features();
             FeatureIterator cpIterator = cpFeatures.features();){
            Feature cpFeature;
            Feature guFeature;
            HashMap<String, Feature> guMap = new HashMap<String, Feature>();
            while (guIterator.hasNext()) {
                guFeature = guIterator.next();
                String guId = guFeature.getIdentifier().getID();
                if (guMap.containsKey(guId)) continue;
                guMap.put(guId, guFeature);
            }
            HashMap<String, Feature> cpMap = new HashMap<String, Feature>();
            while (cpIterator.hasNext()) {
                cpFeature = cpIterator.next();
                String cpId = cpFeature.getIdentifier().getID();
                if (cpMap.containsKey(cpId)) continue;
                cpMap.put(cpId, cpFeature);
            }
            String NESTED_LINK = "specification";
            while (mfIterator.hasNext()) {
                Feature mfFeature = mfIterator.next();
                String mfId = mfFeature.getIdentifier().toString();
                if (mfToGuMap.get(mfId) == null) continue;
                String[] guIds = mfToGuMap.get(mfId).split(";");
                Collection nestedGuFeatures = mfFeature.getProperties("specification");
                Assert.assertEquals((long)guIds.length, (long)nestedGuFeatures.size());
                ArrayList<String> nestedGuIds = new ArrayList<String>();
                for (Property property : nestedGuFeatures) {
                    Object value = property.getValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertTrue((boolean)(value instanceof Collection));
                    Assert.assertEquals((long)1L, (long)((Collection)value).size());
                    Feature nestedGuFeature = (Feature)((Collection)value).iterator().next();
                    String guId = nestedGuFeature.getIdentifier().toString();
                    Assert.assertTrue((boolean)guMap.containsKey(guId));
                    nestedGuIds.add(guId);
                    guFeature = (Feature)guMap.get(guId.toString());
                    Collection guProperties = guFeature.getProperties();
                    Assert.assertEquals((Object)nestedGuFeature.getProperties(), (Object)guProperties);
                    String[] cpIds = guToCpMap.get(guId).split(";");
                    Collection nestedCpFeatures = guFeature.getProperties("composition");
                    Assert.assertEquals((long)cpIds.length, (long)nestedCpFeatures.size());
                    ArrayList<String> nestedCpIds = new ArrayList<String>();
                    for (Property cpProperty : nestedCpFeatures) {
                        Object cpPropertyValue = cpProperty.getValue();
                        Assert.assertNotNull((Object)cpPropertyValue);
                        Assert.assertTrue((boolean)(cpPropertyValue instanceof Collection));
                        Assert.assertEquals((long)1L, (long)((Collection)cpPropertyValue).size());
                        Feature nestedCpFeature = (Feature)((Collection)cpPropertyValue).iterator().next();
                        String cpId = nestedCpFeature.getIdentifier().toString();
                        Assert.assertTrue((boolean)cpMap.containsKey(cpId));
                        nestedCpIds.add(cpId);
                        cpFeature = (Feature)cpMap.get(cpId.toString());
                        Collection cpProperties = cpFeature.getProperties();
                        Assert.assertEquals((Object)nestedCpFeature.getProperties(), (Object)cpProperties);
                    }
                    Assert.assertTrue((boolean)nestedCpIds.containsAll(Arrays.asList(cpIds)));
                }
                Assert.assertTrue((boolean)nestedGuIds.containsAll(Arrays.asList(guIds)));
            }
        }
    }

    @Test
    public void testManyOnChainedSide() throws Exception {
        String LITHOLOGY = "lithology";
        int count = 0;
        HashMap<String, Feature> featureList = new HashMap<String, Feature>();
        try (AbstractMappingFeatureIterator iterator = (AbstractMappingFeatureIterator)ccFeatures.features();){
            while (iterator.hasNext()) {
                Feature f = iterator.next();
                featureList.put(f.getIdentifier().getID(), f);
                ++count;
            }
        }
        Assert.assertEquals((long)5L, (long)count);
        try (FeatureIterator cpIterator = cpFeatures.features();){
            while (cpIterator.hasNext()) {
                Feature cpFeature = cpIterator.next();
                Collection lithologies = cpFeature.getProperties("lithology");
                if (cpFeature.getIdentifier().toString().equals("cp.167775491936278812")) {
                    Assert.assertEquals((long)2L, (long)lithologies.size());
                    ArrayList<String> lithologyIds = new ArrayList<String>();
                    for (Property lithologyProperty : lithologies) {
                        Feature nestedFeature = (Feature)((Collection)lithologyProperty.getValue()).iterator().next();
                        String fId = nestedFeature.getIdentifier().getID();
                        lithologyIds.add(fId);
                        Feature lithology = (Feature)featureList.get(fId);
                        Assert.assertEquals((Object)nestedFeature.getProperties(), (Object)lithology.getProperties());
                    }
                    Assert.assertTrue((boolean)featureList.keySet().containsAll(lithologyIds));
                    continue;
                }
                Assert.assertEquals((long)1L, (long)lithologies.size());
            }
        }
    }

    @Test
    public void testMultipleMultiValuedProperties() throws Exception {
        String EXPOSURE_COLOR = "exposureColor";
        String OUTCROP_CHARACTER = "outcropCharacter";
        try (FeatureIterator guIterator = guFeatures.features();){
            while (guIterator.hasNext()) {
                Feature guFeature = guIterator.next();
                String guId = guFeature.getIdentifier().toString();
                ArrayList<Object> realValues = new ArrayList<Object>();
                Collection nestedTermValues = guFeature.getProperties("exposureColor");
                for (Property property : nestedTermValues) {
                    Object value = property.getValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertTrue((boolean)(value instanceof Collection));
                    Assert.assertEquals((long)1L, (long)((Collection)value).size());
                    Feature feature = (Feature)((Collection)value).iterator().next();
                    for (Property nestedProperty : feature.getProperties("value")) {
                        realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                    }
                }
                String[] values = guToExposureColorMap.get(guId).split(";");
                Assert.assertEquals((long)realValues.size(), (long)values.length);
                Assert.assertTrue((boolean)realValues.containsAll(Arrays.asList(values)));
                nestedTermValues = guFeature.getProperties("outcropCharacter");
                realValues.clear();
                for (Property property : nestedTermValues) {
                    Object value = property.getValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertTrue((boolean)(value instanceof Collection));
                    Assert.assertEquals((long)1L, (long)((Collection)value).size());
                    Feature feature = (Feature)((Collection)value).iterator().next();
                    for (Property nestedProperty : feature.getProperties("value")) {
                        realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                    }
                }
                values = guToOutcropCharacterMap.get(guId).split(";");
                Assert.assertEquals((long)realValues.size(), (long)values.length);
                Assert.assertTrue((boolean)realValues.containsAll(Arrays.asList(values)));
            }
        }
    }

    @Test
    public void testMultiValuedSimpleProperties() throws Exception {
        try (FeatureIterator iterator = ccFeatures.features();){
            while (iterator.hasNext()) {
                Feature next = iterator.next();
                Collection names = next.getProperties("name");
                if (next.getIdentifier().toString().equals("cc.1")) {
                    Assert.assertEquals((long)6L, (long)names.size());
                    continue;
                }
                Assert.assertEquals((long)2L, (long)names.size());
            }
        }
    }

    @Test
    public void testFilters() throws Exception {
        Feature feature;
        PropertyName property = ff.property("gsml:specification/gsml:GeologicUnit/gml:description", this.namespaces);
        PropertyIsLike filter = ff.like((Expression)property, "Olivine basalt, tuff, microgabbro, minor sedimentary rocks");
        FeatureCollection filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)3L, (long)FeatureChainingTest.size(filteredResults));
        try (FeatureIterator iterator = filteredResults.features();){
            feature = iterator.next();
            Assert.assertEquals((Object)"mf1", (Object)feature.getIdentifier().toString());
            feature = iterator.next();
            Assert.assertEquals((Object)"mf2", (Object)feature.getIdentifier().toString());
            feature = iterator.next();
            Assert.assertEquals((Object)"mf3", (Object)feature.getIdentifier().toString());
        }
        FeatureSource guSource = AppSchemaDataAccessRegistry.getFeatureSource((Name)GEOLOGIC_UNIT_NAME);
        property = ff.property("gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", this.namespaces);
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"significant"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)2L, (long)FeatureChainingTest.size(filteredResults));
        try (FeatureIterator iterator = filteredResults.features();){
            Feature feature2 = iterator.next();
            Assert.assertEquals((Object)"gu.25678", (Object)feature2.getIdentifier().toString());
            feature2 = iterator.next();
            Assert.assertEquals((Object)"gu.25682", (Object)feature2.getIdentifier().toString());
        }
        property = ff.property("gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href", this.namespaces);
        filter = ff.like((Expression)property, "urn:cgi:feature:MappedFeature:mf1");
        filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size(filteredResults));
        feature = DataUtilities.first((FeatureCollection)filteredResults);
        Assert.assertEquals((Object)"mf1", (Object)feature.getIdentifier().toString());
        property = ff.property("gml:name");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"Yaugher Volcanic Group 2"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size(filteredResults));
        feature = filteredResults.features().next();
        Assert.assertEquals((Object)"gu.25678", (Object)feature.getIdentifier().toString());
        Collection properties = feature.getProperties(Types.typeName((String)GMLNS, (String)"name"));
        Assert.assertEquals((long)3L, (long)properties.size());
        Iterator propIterator = properties.iterator();
        ComplexAttribute complexAttribute = (ComplexAttribute)propIterator.next();
        Collection values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"Yaugher Volcanic Group 1", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        complexAttribute = (ComplexAttribute)propIterator.next();
        values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"Yaugher Volcanic Group 2", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        complexAttribute = (ComplexAttribute)propIterator.next();
        values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"-Py", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        property = ff.property("gsml:exposureColor/gsml:CGI_TermValue/gsml:value", this.namespaces);
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"Yellow"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size(filteredResults));
        feature = filteredResults.features().next();
        Assert.assertEquals((Object)"gu.25678", (Object)feature.getIdentifier().toString());
        properties = feature.getProperties(Types.typeName((String)GSMLNS, (String)"exposureColor"));
        Assert.assertEquals((long)2L, (long)properties.size());
        propIterator = properties.iterator();
        values = (Collection)((Property)propIterator.next()).getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Feature cgiFeature = (Feature)values.iterator().next();
        Assert.assertEquals((Object)"Blue", (Object)cgiFeature.getIdentifier().toString());
        values = (Collection)((Property)propIterator.next()).getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        cgiFeature = (Feature)values.iterator().next();
        Assert.assertEquals((Object)"Yellow", (Object)cgiFeature.getIdentifier().toString());
    }

    @Test
    public void testComplexTypeWithSimpleContent() throws Exception {
        Feature feature;
        Object value;
        Collection children;
        Feature next;
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/FirstParentFeature.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        Name typeName = Types.typeName((String)"http://example.com", (String)"FirstParentFeature");
        FeatureType featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        FeatureSource fSource = dataAccess.getFeatureSource(typeName);
        FeatureCollection features = fSource.getFeatures();
        Assert.assertEquals((long)5L, (long)FeatureChainingTest.size(features));
        try (FeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                next = iterator.next();
                children = next.getProperties("nestedFeature");
                if (next.getIdentifier().toString().equals("cc.1")) {
                    Assert.assertEquals((long)2L, (long)children.size());
                } else {
                    Assert.assertEquals((long)0L, (long)children.size());
                }
                for (Property nestedFeature : children) {
                    value = nestedFeature.getValue();
                    Assert.assertNotNull((Object)value);
                    value = ((Collection)value).iterator().next();
                    Assert.assertTrue((boolean)(value instanceof FeatureImpl));
                    feature = (Feature)value;
                    Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
                }
            }
        }
        dsParams = new HashMap();
        url = this.getClass().getResource("/test-data/SecondParentFeature.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        typeName = Types.typeName((String)"http://example.com", (String)"SecondParentFeature");
        featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        fSource = dataAccess.getFeatureSource(typeName);
        features = fSource.getFeatures();
        Assert.assertEquals((long)5L, (long)FeatureChainingTest.size(features));
        iterator = features.features();
        try {
            while (iterator.hasNext()) {
                next = iterator.next();
                children = next.getProperties("nestedFeature");
                if (next.getIdentifier().toString().equals("cc.2")) {
                    Assert.assertEquals((long)3L, (long)children.size());
                } else {
                    Assert.assertEquals((long)0L, (long)children.size());
                }
                for (Property nestedFeature : children) {
                    value = nestedFeature.getValue();
                    Assert.assertNotNull((Object)value);
                    value = ((Collection)value).iterator().next();
                    Assert.assertTrue((boolean)(value instanceof FeatureImpl));
                    feature = (Feature)value;
                    Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
                }
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        dataAccess.dispose();
    }

    @Test
    public void testMultiValuedPropertiesByRef() throws Exception {
        String MF_PREFIX = "urn:cgi:feature:MappedFeature:";
        String OCCURENCE = "occurrence";
        HashMap<String, String> guToOccurrenceMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "mf1");
                this.put("gu.25678", "mf2;mf3");
                this.put("gu.25682", "mf4");
            }
        };
        ArrayList<String> processedFeatureIds = new ArrayList<String>();
        try (FeatureIterator guIterator = guFeatures.features();){
            while (guIterator.hasNext()) {
                Feature guFeature = guIterator.next();
                String guId = guFeature.getIdentifier().toString();
                String[] mfIds = ((String)guToOccurrenceMap.get(guId)).split(";");
                Collection properties = guFeature.getProperties("occurrence");
                Assert.assertEquals((long)mfIds.length, (long)properties.size());
                int propertyIndex = 0;
                for (Property property : properties) {
                    Object clientProps = property.getUserData().get(Attributes.class);
                    Assert.assertNotNull(clientProps);
                    Assert.assertTrue((boolean)(clientProps instanceof HashMap));
                    Object hrefValue = ((Map)clientProps).get(AbstractMappingFeatureIterator.XLINK_HREF_NAME);
                    Assert.assertEquals((Object)("urn:cgi:feature:MappedFeature:" + mfIds[propertyIndex]), hrefValue);
                    Assert.assertTrue((boolean)((Collection)property.getValue()).isEmpty());
                    ++propertyIndex;
                }
                processedFeatureIds.add(guId);
            }
            Assert.assertEquals((long)guToOccurrenceMap.size(), (long)processedFeatureIds.size());
            Assert.assertTrue((boolean)processedFeatureIds.containsAll(guToOccurrenceMap.keySet()));
        }
    }

    @Test
    public void testSourceDataStoreConsolidation() throws IOException {
        FeatureSource guFs = DataAccessRegistry.getFeatureSource((Name)GEOLOGIC_UNIT_NAME);
        Assert.assertTrue((boolean)(guFs instanceof MappingFeatureSource));
        FeatureTypeMapping guMapping = ((MappingFeatureSource)guFs).getMapping();
        FeatureSource cpFs = DataAccessRegistry.getFeatureSource((Name)COMPOSITION_PART);
        Assert.assertTrue((boolean)(cpFs instanceof MappingFeatureSource));
        FeatureTypeMapping cpMapping = ((MappingFeatureSource)cpFs).getMapping();
        FeatureSource ccFs = DataAccessRegistry.getFeatureSource((Name)CONTROLLED_CONCEPT);
        Assert.assertTrue((boolean)(ccFs instanceof MappingFeatureSource));
        FeatureTypeMapping ccMapping = ((MappingFeatureSource)ccFs).getMapping();
        FeatureSource cgiFs = DataAccessRegistry.getFeatureSource((Name)CGI_TERM_VALUE);
        Assert.assertTrue((boolean)(cgiFs instanceof MappingFeatureSource));
        FeatureTypeMapping cgiMapping = ((MappingFeatureSource)cgiFs).getMapping();
        FeatureSource guSourceFs = guMapping.getSource();
        Assert.assertEquals((Object)guSourceFs.getDataStore(), (Object)cpMapping.getSource().getDataStore());
        Assert.assertEquals((Object)guSourceFs.getDataStore(), (Object)ccMapping.getSource().getDataStore());
        Assert.assertEquals((Object)guSourceFs.getDataStore(), (Object)cgiMapping.getSource().getDataStore());
        FeatureSource mfSource = DataAccessRegistry.getFeatureSource((Name)MAPPED_FEATURE);
        Assert.assertTrue((boolean)(mfSource instanceof MappingFeatureSource));
        FeatureTypeMapping mfMapping = ((MappingFeatureSource)mfSource).getMapping();
        FeatureSource mfSourceFs = mfMapping.getSource();
        Assert.assertNotEquals((Object)guSourceFs.getDataStore(), (Object)mfSourceFs.getDataStore());
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = FeatureChainingTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(MAPPED_FEATURE);
        Assert.assertNotNull((Object)mappedFeatureType);
        mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        mfFeatures = mfSource.getFeatures();
        url = FeatureChainingTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        FeatureType guType = guDataAccess.getSchema(GEOLOGIC_UNIT);
        Assert.assertNotNull((Object)guType);
        FeatureSource guSource = guDataAccess.getFeatureSource(GEOLOGIC_UNIT);
        guFeatures = guSource.getFeatures();
        cpFeatures = DataAccessRegistry.getFeatureSource((Name)COMPOSITION_PART).getFeatures();
        FeatureCollection cgiFeatures = DataAccessRegistry.getFeatureSource((Name)CGI_TERM_VALUE).getFeatures();
        ccFeatures = DataAccessRegistry.getFeatureSource((Name)CONTROLLED_CONCEPT).getFeatures();
        Assert.assertEquals((long)5L, (long)FeatureChainingTest.size(mfFeatures));
        Assert.assertEquals((long)3L, (long)FeatureChainingTest.size(guFeatures));
        Assert.assertEquals((long)4L, (long)FeatureChainingTest.size(cpFeatures));
        Assert.assertEquals((long)6L, (long)FeatureChainingTest.size(cgiFeatures));
    }

    @Test
    public void testPropertyValueCollection() {
        PropertyName pn = ff.property("gsml:specification/gsml:GeologicUnit/gsml:purpose");
        PropertyDescriptor descriptor = (PropertyDescriptor)pn.evaluate((Object)mfFeatures.getSchema(), null);
        PropertyValueCollection propertyValueCollection = new PropertyValueCollection(mfFeatures, (AttributeDescriptor)descriptor, pn);
        for (Attribute attribute : propertyValueCollection) {
            Assert.assertFalse((boolean)(attribute.getType() instanceof ComplexType));
        }
    }

    private static int size(FeatureCollection features) {
        int size = 0;
        try (FeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            int n = size;
            return n;
        }
    }

    static {
        mfToGuMap = new HashMap<String, String>(){
            {
                this.put("mf1", "gu.25699");
                this.put("mf2", "gu.25678");
                this.put("mf3", "gu.25678");
                this.put("mf4", "gu.25682");
            }
        };
        guToCpMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "cp.167775491936278899");
                this.put("gu.25678", "cp.167775491936278844;cp.167775491936278856");
                this.put("gu.25682", "cp.167775491936278812");
            }
        };
        guToExposureColorMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "Blue");
                this.put("gu.25678", "Yellow;Blue");
                this.put("gu.25682", "Red");
            }
        };
        guToOutcropCharacterMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "x");
                this.put("gu.25678", "x;y");
                this.put("gu.25682", "z");
            }
        };
    }
}

